/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import java.math.BigInteger;
import java.util.ArrayList;

public class ParseUtils {
    private static ParseUtils instance;

    public static ParseUtils getInstance() {
        if (instance == null) {
            instance = new ParseUtils();
        }
        return instance;
    }

    private ParseUtils() {
    }

    public static String parseDecimalStringToHexString(String string) {
        return String.format("%X ", new BigInteger(string.getBytes()));
    }

    public static byte[] parseASCIIStringToByteArray(String ascii) {
        int length = ascii.length();
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = (byte)ascii.charAt(i);
        }
        return b;
    }

    public static byte[] parseHexStringToByteArray(String sarray) {
        ArrayList<String> separated = new ArrayList<String>();
        for (int index = 0; index < sarray.length(); index += 2) {
            separated.add(sarray.substring(index, Math.min(index + 2, sarray.length())));
        }
        byte[] b = new byte[separated.size()];
        for (int i = 0; i < separated.size(); ++i) {
            try {
                b[i] = (byte)Integer.parseInt((String)separated.get(i), 16);
                continue;
            }
            catch (NumberFormatException e) {
                b[i] = -1;
            }
        }
        return b;
    }

    public static byte[] parseStringToByteArray(String sarray, int radix) {
        ArrayList<String> separated = new ArrayList<String>();
        int width = (int)Math.ceil(Math.log10(255.0) / Math.log10(radix));
        for (int index = 0; index < sarray.length(); index += width) {
            String s = sarray.substring(index, Math.min(index + width, sarray.length()));
            if (Integer.parseInt(s, radix) > 255) {
                sarray = sarray.substring(0, index) + "0" + sarray.substring(index, sarray.length());
                s = sarray.substring(index, Math.min(index + width, sarray.length()));
            }
            separated.add(s);
        }
        byte[] b = new byte[separated.size()];
        for (int i = 0; i < separated.size(); ++i) {
            try {
                b[i] = (byte)Integer.parseInt((String)separated.get(i), radix);
                continue;
            }
            catch (NumberFormatException e) {
                b[i] = -1;
            }
        }
        return b;
    }

    public static byte[] parseIntegerToByteArray(int intad) {
        String HexStr = Integer.toHexString(intad);
        return ParseUtils.parseHexStringToByteArray(HexStr);
    }

    public static byte[] parseIntegerToByteArray(int intad, int length) {
        String HexStr = Integer.toHexString(intad);
        length <<= 1;
        while (HexStr.length() < length) {
            HexStr = "0" + HexStr;
        }
        if (HexStr.length() > length) {
            HexStr = HexStr.substring(HexStr.length() - length);
        }
        return ParseUtils.parseHexStringToByteArray(HexStr);
    }

    public static String parseByteToHexString(byte bytead) {
        return ("" + String.format("%02x", bytead & 0xFF)).toUpperCase();
    }

    public static String parseByteArrayToASCIIString(byte[] barray) {
        StringBuilder strBuilder = new StringBuilder();
        for (byte aBarray : barray) {
            strBuilder.append((char)aBarray);
        }
        return strBuilder.toString();
    }

    public static String parseByteArrayToHexString(byte[] barray) {
        StringBuilder hexString = new StringBuilder("");
        if (barray == null) {
            return "";
        }
        for (byte b : barray) {
            hexString.append(String.format("%02x", b & 0xFF));
        }
        return hexString.toString();
    }

    public static String parseByteArrayToString(byte[] barray, int radix) {
        StringBuilder string = new StringBuilder("");
        int width = (int)Math.ceil(Math.log10(255.0) / Math.log10(radix));
        for (byte b : barray) {
            String temp = Integer.toString(b & 0xFF, radix);
            while (temp.length() % width != 0) {
                temp = "0" + temp;
            }
            string.append(temp);
        }
        return string.toString();
    }

    public static byte[] concatenateByteArray(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }

    public static String getOrdinal(int packetNumber) {
        String ordinal;
        if (packetNumber / 10 % 10 == 1) {
            ordinal = packetNumber + "th";
        } else {
            switch (packetNumber % 10) {
                case 1: {
                    ordinal = packetNumber + "st";
                    break;
                }
                case 2: {
                    ordinal = packetNumber + "nd";
                    break;
                }
                case 3: {
                    ordinal = packetNumber + "rd";
                    break;
                }
                default: {
                    ordinal = packetNumber + "th";
                }
            }
        }
        return ordinal;
    }
}

