/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import com.sic.module.utils.SICLog;

public class Buffer {
    private static final String TAG = Buffer.class.getSimpleName();
    private final int length;
    private final byte[] data;
    private final boolean[] sync;

    public Buffer(int length) {
        this.length = length;
        this.data = new byte[length];
        this.sync = new boolean[length];
    }

    public static Buffer newInstance(int length) {
        return new Buffer(length);
    }

    public void set(int index, byte data) {
        if (index >= this.length) {
            return;
        }
        this.data[index] = data;
        this.sync[index] = true;
    }

    public void set(int[] index, byte[] data) {
        if (index.length != data.length) {
            SICLog.i(TAG, "size is mismatch");
            return;
        }
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.data[index[i]] = data[i];
            this.sync[index[i]] = true;
        }
    }

    public void set(byte[] ... dataBytes) {
        for (byte[] dataArrays : dataBytes) {
            byte data;
            if (dataArrays.length != 2) {
                SICLog.i(TAG, "size is mismatch");
                continue;
            }
            int index = dataArrays[0] & 0xFF;
            this.data[index] = data = dataArrays[1];
            this.sync[index] = true;
        }
    }

    public Byte get(int index) {
        if (index >= this.length) {
            return null;
        }
        if (!this.sync[index]) {
            return null;
        }
        return this.data[index];
    }

    public void unsync(int index) {
        this.sync[index] = false;
        this.data[index] = 0;
    }

    public boolean isSync() {
        for (boolean s : this.sync) {
            if (s) continue;
            return false;
        }
        return true;
    }

    public boolean isSyncAt(int index) {
        return this.sync[index];
    }
}

