/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.interfaces;

import com.sic.module.nfc.tech.interfaces.IDefine;
import com.sic.module.nfc.tech.mandatories.NfcTypeA;
import com.sic.module.utils.Buffer;
import com.sic.module.utils.Utils;

public abstract class IRegister
implements IDefine {
    private static final String TAG = IRegister.class.getSimpleName();
    private final NfcTypeA mNfcA;
    private final Buffer mRegBuffer;

    protected IRegister(NfcTypeA nfc) {
        this.mNfcA = nfc;
        this.mRegBuffer = Buffer.newInstance(this.getRegisterPage());
    }

    public static byte[] getPackage_ClearFlags() {
        return new byte[]{-76, -1};
    }

    public static byte[] getPackage_Read(int address) {
        return new byte[]{-75, (byte)address};
    }

    public static byte[] getPackage_Write(int address, int data) {
        return new byte[]{-74, (byte)address, (byte)data};
    }

    public static byte[] getPackage_Write(byte[] data) {
        if (Utils.checkArraySize(data, 2, data.length)) {
            return new byte[]{-74, data[0], data[1]};
        }
        return null;
    }

    protected abstract int getRegisterPage();

    public byte readBuffer(int address) {
        if (this.mRegBuffer.isSyncAt(address)) {
            return this.mRegBuffer.get(address);
        }
        Byte recv = this.read(address);
        if (recv == null) {
            return 0;
        }
        return recv;
    }

    public Byte read(int address) {
        byte[] recv = this.mNfcA.autoTransceive(IRegister.getPackage_Read(address));
        if (this.mNfcA.isSendCompleted()) {
            this.mRegBuffer.set(address, recv[1]);
            return recv[1];
        }
        return null;
    }

    public byte[] read(byte[] addrBytes) {
        int length = addrBytes.length;
        byte[] recv = new byte[length];
        this.mNfcA.clearDataStream();
        for (byte address : addrBytes) {
            this.mNfcA.addDataStream(new byte[][]{IRegister.getPackage_Read(address & 0xFF)});
        }
        this.mNfcA.stream();
        if (this.mNfcA.isSendCompleted()) {
            for (int i = 0; i < length; ++i) {
                recv[i] = this.mNfcA.getDataStreamAt(i)[1];
            }
            this.mRegBuffer.set(addrBytes, recv);
            return recv;
        }
        return null;
    }

    public void write(int address, int data) {
        this.mNfcA.autoTransceive(IRegister.getPackage_Write(address, data));
        if (this.mNfcA.isSendCompleted()) {
            this.mRegBuffer.set(address, (byte)data);
        }
    }

    public void write(byte[] ... addr_dataBytes) {
        this.mNfcA.clearDataStream();
        for (byte[] data : addr_dataBytes) {
            this.mNfcA.addDataStream(new byte[][]{IRegister.getPackage_Write(data)});
        }
        this.mNfcA.stream();
        if (this.mNfcA.isSendCompleted()) {
            this.mRegBuffer.set(addr_dataBytes);
        }
    }

    public void clearFlags() {
        this.mNfcA.autoTransceive(IRegister.getPackage_ClearFlags());
    }

    public void writeParams(int address, int pos, int valPos) {
        int bConfig = this.readBuffer(address) & (~pos & 0xFF);
        this.write(address, bConfig | (valPos &= pos));
    }

    public static enum RegisterType {
        NULL,
        RFU,
        READ_ONLY_STATUS,
        READ_WRITE_CONFIG,
        READ_WRITE,
        READ_ONLY;

    }
}

