/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.sic4310;

import com.sic.module.nfc.tech.chips.SIC4310;
import com.sic.module.nfc.tech.chips.registers.IUART;
import com.sic.module.nfc.tech.chips.sic4310.GPIO;
import com.sic.module.nfc.tech.interfaces.IDefine;

public class UART
extends IUART {
    private static final String TAG = UART.class.getName();
    private static UART instance;

    private UART(SIC4310 sic4310) {
        super(sic4310);
    }

    public static UART getInstance(SIC4310 sic4310) {
        if (instance == null) {
            instance = new UART(sic4310);
        }
        return instance;
    }

    @Override
    protected void setRegisterAddress() {
        ADDRESS_TRXRU_RESPONSE_TIME = (byte)3;
        ADDRESS_UART_BYTE_CONFIGURATION = (byte)4;
        ADDRESS_UART_DIVISOR_M = (byte)5;
        ADDRESS_UART_DIVISOR_N = (byte)6;
    }

    @Override
    protected void setDefaultBit() {
        SPEED_OF_UART = 1843200;
        MAX_SIZE_FIFO = 64;
        TRXRU_RESPONSE_TIME = IDefine.Bit.parseBit(3, 2, 1, 0);
        STOP_BITS = IDefine.Bit.parseBit(3);
        PARITY = IDefine.Bit.parseBit(2, 1, 0);
        TRxRURespTimeShiftBit = 0;
        StopBits_1 = IDefine.Bit.parseBit();
        StopBits_2 = IDefine.Bit.parseBit(3);
        Parity_None = IDefine.Bit.parseBit();
        Parity_Space = IDefine.Bit.parseBit(2);
        Parity_Mask = IDefine.Bit.parseBit(2, 0);
        Parity_Even = IDefine.Bit.parseBit(2, 1);
        Parity_Odd = IDefine.Bit.parseBit(2, 1, 0);
        Mode_CTS = GPIO.Pin_UART_CTS;
        Mode_Tx = GPIO.Pin_UART_TXD;
        Mode_Rx = GPIO.Pin_UART_RXD;
        Mode_RTS = GPIO.Pin_UART_RTS;
    }

    @Override
    public byte getMode() {
        int direction = this.mRegister.readBuffer(8) & 0xF;
        int mode = this.mRegister.readBuffer(9) & 0xF;
        return (byte)((~direction & 5 | direction & 0xA) & mode);
    }

    @Override
    public void setMode(int UART_Mode) {
        int direction = UART_Mode & 0xA | ~UART_Mode & this.mRegister.readBuffer(8);
        int mode = UART_Mode & 0xF | ~UART_Mode & this.mRegister.readBuffer(9);
        this.mRegister.write({8, (byte)direction}, {9, (byte)mode});
    }
}

