/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.sic4310;

import com.sic.module.nfc.tech.chips.SIC4310;
import com.sic.module.nfc.tech.interfaces.IDefine;
import com.sic.module.nfc.tech.interfaces.IDevice;

public class Peripheral
extends IDevice {
    public static final byte CONFIG_PW_LV = IDefine.Bit.parseBit(5, 4);
    public static final byte CONFIG_PWCHK_EN = IDefine.Bit.parseBit(2);
    public static final byte CONFIG_LDO_EN = IDefine.Bit.parseBit(1);
    public static final byte CONFIG_OSC_EN = IDefine.Bit.parseBit(0);
    public static final byte ADJUSTMENT_LDO_D_LV = IDefine.Bit.parseBit(2);
    public static final byte ADJUSTMENT_RFLM_LV = IDefine.Bit.parseBit(1);
    public static final byte ADJUSTMENT_RESP_2B_FLAG = IDefine.Bit.parseBit(0);
    public static final byte PowerLv_500_UA = IDefine.Bit.parseBit();
    public static final byte PowerLv_1250_UA = IDefine.Bit.parseBit(4);
    public static final byte PowerLv_2500_UA = IDefine.Bit.parseBit(5);
    public static final byte PowerLv_5000_UA = IDefine.Bit.parseBit(5, 4);
    public static final byte PowerCheck_Disable = IDefine.Bit.parseBit();
    public static final byte PowerCheck_Enable = IDefine.Bit.parseBit(2);
    public static final byte LDO_Disable = IDefine.Bit.parseBit();
    public static final byte LDO_Enable = IDefine.Bit.parseBit(1);
    public static final byte OSC_Disable = IDefine.Bit.parseBit();
    public static final byte OSC_Enable = IDefine.Bit.parseBit(0);
    public static final byte LDODropLv_2_4 = IDefine.Bit.parseBit();
    public static final byte LDODropLv_2_7 = IDefine.Bit.parseBit(2);
    public static final byte RFLimitLv_5_2 = IDefine.Bit.parseBit();
    public static final byte RFLimitLv_6_5 = IDefine.Bit.parseBit(1);
    public static final byte RespBitFlag_1 = IDefine.Bit.parseBit();
    public static final byte RespBitFlag_2 = IDefine.Bit.parseBit(0);
    private static final String TAG = Peripheral.class.getName();
    private static final int ADDRESS_PERIPHERAL_CONFIG = 13;
    private static final int ADDRESS_PERIPHERAL_ADJUSTMENT = 14;
    private static Peripheral instance;

    private Peripheral(SIC4310 sic4310) {
        super(sic4310.getRegister());
    }

    public static Peripheral getInstance(SIC4310 sic4310) {
        if (instance == null) {
            instance = new Peripheral(sic4310);
        }
        return instance;
    }

    @Override
    protected void setRegisterAddress() {
    }

    @Override
    protected void setDefaultBit() {
    }

    public void setPowerLevel(int PW_Level) {
        this.mRegister.writeParams(13, CONFIG_PW_LV, PW_Level);
    }

    public void setPowerCheckEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, CONFIG_PWCHK_EN, PowerCheck_Enable);
        } else {
            this.mRegister.writeParams(13, CONFIG_PWCHK_EN, PowerCheck_Disable);
        }
    }

    public void setLDORegulatorEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, CONFIG_LDO_EN, LDO_Enable);
        } else {
            this.mRegister.writeParams(13, CONFIG_LDO_EN, LDO_Disable);
        }
    }

    public void setUARTOscillatorEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, CONFIG_OSC_EN, OSC_Enable);
        } else {
            this.mRegister.writeParams(13, CONFIG_OSC_EN, OSC_Disable);
        }
    }

    public void setVoltageDropLevel(int LDO_DropLevel) {
        this.mRegister.writeParams(14, ADJUSTMENT_LDO_D_LV, LDO_DropLevel);
    }

    public void setRFLimiterLevel(int RFLM_Level) {
        this.mRegister.writeParams(13, ADJUSTMENT_RFLM_LV, RFLM_Level);
    }

    public void setResponseFlags(int RESP_Flag) {
        this.mRegister.writeParams(13, ADJUSTMENT_RESP_2B_FLAG, RESP_Flag);
    }
}

