/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.sic4310;

import com.sic.module.nfc.tech.chips.SIC4310;
import com.sic.module.nfc.tech.chips.registers.IGPIO;

public class GPIO
extends IGPIO {
    public static final int Direction_Input = 0;
    public static final int Direction_Output = 1;
    public static final int NoPull = 0;
    public static final int PullUp = 1;
    public static final int Mode_GPIO = 0;
    public static final int Mode_Functional = 1;
    private static final String TAG = GPIO.class.getName();
    private static final byte ADDRESS_GPIO_DIRECTION = 8;
    private static final byte ADDRESS_GPIO_MODE = 9;
    public static int Pin_UART_CTS;
    public static int Pin_UART_TXD;
    public static int Pin_UART_RXD;
    public static int Pin_UART_RTS;
    private static GPIO instance;

    private GPIO(SIC4310 sic4310) {
        super(sic4310);
    }

    public static GPIO getInstance(SIC4310 sic4310) {
        if (instance == null) {
            instance = new GPIO(sic4310);
        }
        return instance;
    }

    @Override
    protected void setRegisterAddress() {
        ADDRESS_GPIO_MODE_0 = (byte)8;
        ADDRESS_GPIO_MODE_1 = (byte)9;
        ADDRESS_GPIO_OUT = (byte)10;
        ADDRESS_GPIO_IN = (byte)11;
        ADDRESS_GPIO_MODE_2 = (byte)12;
    }

    @Override
    protected void setDefaultBit() {
        Pin_UART_CTS = Pin_0;
        Pin_UART_TXD = Pin_1;
        Pin_UART_RXD = Pin_2;
        Pin_UART_RTS = Pin_3;
        Pin_Power_Ready = Pin_4;
        Pin_RF_Busy = Pin_5;
        Pin_RF_Detected = Pin_6;
    }

    @Override
    @Deprecated
    public Byte getMode(int number) {
        return super.getMode(1);
    }

    @Override
    @Deprecated
    public void setMode(int number, int GPIO_Mode) {
        super.setMode(1, GPIO_Mode);
    }

    @Override
    @Deprecated
    public void setModeBit(int number, int GPIO_Pin, int GPIO_Mode) {
        super.setModeBit(1, GPIO_Pin, GPIO_Mode);
    }

    public byte getDirection() {
        return super.getMode(0);
    }

    public void setDirection(int GPIO_Direction) {
        super.setMode(0, GPIO_Direction);
    }

    public void setDirectionBit(int GPIO_Pin, int GPIO_Direction) {
        super.setModeBit(0, GPIO_Pin, GPIO_Direction);
    }

    public Byte getMode() {
        return super.getMode(1);
    }

    public void setMode(int GPIO_Mode) {
        super.setMode(1, GPIO_Mode);
    }

    public void setModeBit(int GPIO_Pin, int GPIO_Mode) {
        super.setModeBit(1, GPIO_Pin, GPIO_Mode);
    }

    public Byte getPullUp() {
        return super.getMode(2);
    }

    public void setPullUp(int GPIO_PullUp) {
        super.setMode(2, GPIO_PullUp);
    }

    public void setBitPullup(int GPIO_Pin, int GPIO_PullUp) {
        super.setModeBit(2, GPIO_Pin, GPIO_PullUp);
    }

    public void setGPIOModeInputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer(8) & ~GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer(9) & ~GPIO_Pin);
        this.mRegister.write({8, direction}, {9, mode});
    }

    public void setGPIOModeOutputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer(8) | GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer(9) & ~GPIO_Pin);
        this.mRegister.write({8, direction}, {9, mode});
    }

    public void setFunctionModeInputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer(8) & ~GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer(9) | GPIO_Pin);
        this.mRegister.write({8, direction}, {9, mode});
    }

    public void setFunctionModeOutputDirection(int GPIO_Pin) {
        byte direction = (byte)(this.mRegister.readBuffer(8) | GPIO_Pin);
        byte mode = (byte)(this.mRegister.readBuffer(9) | GPIO_Pin);
        this.mRegister.write({8, direction}, {9, mode});
    }
}

