/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.registers;

import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.interfaces.IDevice;
import com.sic.module.utils.SICLog;

public abstract class IGPIO
extends IDevice {
    public static final int Address_Mode_0 = 0;
    public static final int Address_Mode_1 = 1;
    public static final int Address_Mode_2 = 2;
    public static final int Pin_0 = BIT0;
    public static final int Pin_1 = BIT1;
    public static final int Pin_2 = BIT2;
    public static final int Pin_3 = BIT3;
    public static final int Pin_4 = BIT4;
    public static final int Pin_5 = BIT5;
    public static final int Pin_6 = BIT6;
    public static final int Pin_7 = BIT7;
    public static final int Pin_LNib = BIT0 | BIT1 | BIT2 | BIT3;
    public static final int Pin_HNib = BIT4 | BIT5 | BIT6 | BIT7;
    public static final int Pin_All = Pin_LNib | Pin_HNib;
    private static final String TAG = IGPIO.class.getName();
    public static int Pin_Power_Ready;
    public static int Pin_RF_Busy;
    public static int Pin_RF_Detected;
    protected static byte ADDRESS_GPIO_MODE_0;
    protected static byte ADDRESS_GPIO_MODE_1;
    protected static byte ADDRESS_GPIO_MODE_2;
    protected static byte ADDRESS_GPIO_OUT;
    protected static byte ADDRESS_GPIO_IN;
    private int[] ADDRESS_GPIO_MODE = new int[3];

    protected IGPIO(SIC43xx sic43xx) {
        super(sic43xx.getRegister());
        this.ADDRESS_GPIO_MODE[0] = ADDRESS_GPIO_MODE_0;
        this.ADDRESS_GPIO_MODE[1] = ADDRESS_GPIO_MODE_1;
        this.ADDRESS_GPIO_MODE[2] = ADDRESS_GPIO_MODE_2;
    }

    public Byte getMode(int GPIO_Address_Mode) {
        return this.mRegister.readBuffer(this.ADDRESS_GPIO_MODE[GPIO_Address_Mode]);
    }

    public void setMode(int GPIO_Address_Mode, int GPIO_Pin_Mode) {
        this.mRegister.write(this.ADDRESS_GPIO_MODE[GPIO_Address_Mode], GPIO_Pin_Mode);
    }

    public void setModeBit(int GPIO_Address_Mode, int GPIO_Pin, int GPIO_Pin_Mode) {
        byte mode = this.mRegister.readBuffer(this.ADDRESS_GPIO_MODE[GPIO_Address_Mode]);
        mode = GPIO_Pin_Mode == 0 ? (byte)(mode & ~GPIO_Pin) : (byte)(mode | GPIO_Pin);
        this.mRegister.write(this.ADDRESS_GPIO_MODE[GPIO_Address_Mode], mode);
    }

    public byte getOutput() {
        return this.mRegister.readBuffer(ADDRESS_GPIO_OUT);
    }

    public void setOutput(int GPIO_PortVal) {
        this.mRegister.write(ADDRESS_GPIO_OUT, GPIO_PortVal);
    }

    public void setOutputBit(int GPIO_Pin, int GPIO_BitVal) {
        byte output = this.mRegister.readBuffer(ADDRESS_GPIO_OUT);
        output = GPIO_BitVal == 0 ? (byte)(output & ~GPIO_Pin) : (byte)(output | GPIO_Pin);
        this.mRegister.write(ADDRESS_GPIO_OUT, output);
    }

    public Byte getInput() {
        Byte recv = this.mRegister.read(ADDRESS_GPIO_IN);
        if (recv == null) {
            SICLog.e(TAG, "Can not get GPIO input.");
        }
        return recv;
    }

    public Byte getInputBit(int GPIO_Pin) {
        Byte recv = this.mRegister.read(ADDRESS_GPIO_IN);
        if (recv == null) {
            SICLog.e(TAG, "Can not get GPIO input.");
            return null;
        }
        if ((recv & GPIO_Pin) == GPIO_Pin) {
            return (byte)1;
        }
        return (byte)0;
    }

    public void setHighOutput(int GPIO_Pin) {
        this.setOutputBit(GPIO_Pin, 1);
    }

    public void setLowOutput(int GPIO_Pin) {
        this.setOutputBit(GPIO_Pin, 0);
    }

    public void setToggleOutput(int GPIO_Pin) {
        byte output = this.getOutput();
        byte sel = (byte)(GPIO_Pin & ~output);
        byte uns = (byte)(~GPIO_Pin & output);
        this.setOutput((byte)(sel | uns));
    }
}

