/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.interfaces;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 27/Nov/2015
 */
public interface IDefine {
    int Low_Level = 0;
    int High_Level = 1;

    byte BIT7 = Bit.BIT_7.bit;
    byte BIT6 = Bit.BIT_6.bit;
    byte BIT5 = Bit.BIT_5.bit;
    byte BIT4 = Bit.BIT_4.bit;
    byte BIT3 = Bit.BIT_3.bit;
    byte BIT2 = Bit.BIT_2.bit;
    byte BIT1 = Bit.BIT_1.bit;
    byte BIT0 = Bit.BIT_0.bit;

    enum Bit {
        BIT_7(0x80),
        BIT_6(0x40),
        BIT_5(0x20),
        BIT_4(0x10),
        BIT_3(0x08),
        BIT_2(0x04),
        BIT_1(0x02),
        BIT_0(0x01);

        private final byte bit;

        Bit(int bit) {
            this.bit = (byte) (bit & 0xFF);
        }

        public static byte parseBit() {
            return 0x00;
        }

        public static byte parseBit(Bit... bits) {
            byte sum = 0x00;
            for (Bit bit : bits) {
                sum |= bit.getByte();
            }
            return sum;

        }

        public static byte parseBit(int... bits) {
            byte sum = 0x00;
            for (int bit : bits) {
                sum |= (int) Math.pow(2, bit) & 0xff;
            }
            return sum;
        }

        public byte getByte() {
            return bit;
        }
    }
}
