/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.sic4310;


import com.sic.module.nfc.tech.chips.SIC4310;
import com.sic.module.nfc.tech.chips.registers.IUART;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.2
 * @since 25/Nov/2015
 */
public class UART extends IUART {

    private static final String TAG = UART.class.getName();

    private static UART instance;

    private UART(SIC4310 sic4310) {
        super(sic4310);
    }

    public static UART getInstance(SIC4310 sic4310) {
        if (instance == null)
            instance = new UART(sic4310);
        return instance;
    }

    @Override
    protected void setRegisterAddress() {
        ADDRESS_TRXRU_RESPONSE_TIME = Register.TRXRU_RESPONSE_TIME;
        ADDRESS_UART_BYTE_CONFIGURATION = Register.UART_BYTE_CONFIGURATION;
        ADDRESS_UART_DIVISOR_M = Register.UART_DIVISOR_M;
        ADDRESS_UART_DIVISOR_N = Register.UART_DIVISOR_N;
    }

    @Override
    protected void setDefaultBit() {
        SPEED_OF_UART = 1843200;
        MAX_SIZE_FIFO = 64;

        TRXRU_RESPONSE_TIME = Bit.parseBit(3, 2, 1, 0);
        STOP_BITS = Bit.parseBit(3);
        PARITY = Bit.parseBit(2, 1, 0);

        TRxRURespTimeShiftBit = 0;

        StopBits_1 = Bit.parseBit();
        StopBits_2 = Bit.parseBit(3);

        Parity_None = Bit.parseBit();
        Parity_Space = Bit.parseBit(2);
        Parity_Mask = Bit.parseBit(2, 0);
        Parity_Even = Bit.parseBit(2, 1);
        Parity_Odd = Bit.parseBit(2, 1, 0);

        Mode_CTS = GPIO.Pin_UART_CTS;
        Mode_Tx = GPIO.Pin_UART_TXD;
        Mode_Rx = GPIO.Pin_UART_RXD;
        Mode_RTS = GPIO.Pin_UART_RTS;
    }

    @Override
    public byte getMode() {
        int direction = mRegister.readBuffer(Register.GPIO_DIRECTION) & 0x0F;
        int mode = mRegister.readBuffer(Register.GPIO_MODE) & 0x0F;
        return (byte) (((~direction & 0x05) | (direction & 0x0A)) & mode);
    }

    @Override
    public void setMode(int UART_Mode) {
        int direction = (UART_Mode & 0x0A) | (~UART_Mode & mRegister.readBuffer(Register.GPIO_DIRECTION));
        int mode = (UART_Mode & 0x0F) | (~UART_Mode & mRegister.readBuffer(Register.GPIO_MODE));
        mRegister.write(
                new byte[]{Register.GPIO_DIRECTION, (byte) direction},
                new byte[]{Register.GPIO_MODE, (byte) mode});
    }

}
