/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.registers;

import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.interfaces.IDevice;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.2
 * @since 25/Nov/2015
 */
public abstract class IADC extends IDevice {

    private static final String TAG = IADC.class.getName();
    protected static byte ADDRESS_ANALOG_CFG;
    protected static byte ADDRESS_ADC_RESULT_2;
    protected static byte ADDRESS_ADC_RESULT_1;
    protected static byte ADDRESS_ADC_RESULT_0;
    protected SIC43xx mSic43xx;

    protected IADC(SIC43xx sic43xx) {
        super(sic43xx.getRegister());
        mSic43xx = sic43xx;
    }

    /**
     * Gets the Convert ADC protocol.
     *
     * @return byte array, ConvADC command
     */
    public static byte[] getPackage_ConvADC() {
        return new byte[]{(byte) 0xB8, (byte) 0x00};
    }


    /**
     * Returns the data conversion of SIC's chip.
     *
     * @return byte array, response flag and ADC's data from NFC tag.
     */
    public byte[] convADC() {
        return mSic43xx.autoTransceive(getPackage_ConvADC());
    }

}
