/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips;

import android.content.Context;

import com.sic.module.nfc.tech.chips.sic4310.GPIO;
import com.sic.module.nfc.tech.chips.sic4310.Peripheral;
import com.sic.module.nfc.tech.chips.sic4310.Register;
import com.sic.module.nfc.tech.chips.sic4310.UART;
import com.sic.module.utils.AppContext;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.2
 * @since 25/Nov/2015
 */
public class SIC4310 extends SIC431x {

    private static final byte SIC4310_UID = 0x02;
    private static final String TAG = SIC4310.class.getName();

    private static SIC4310 instance;
    private GPIO mGPIO;
    private UART mUART;
    private Peripheral mPeripheral;

    private SIC4310(Context context) {
        super(context);
    }

    public static SIC4310 getInstance() {
        return getInstance(AppContext.getInstance().getContext());
    }

    public static SIC4310 getInstance(Context context) {
        if (instance == null) {
            instance = new SIC4310(context);
        }
        return instance;
    }

    @Override
    /**
     * Checks a UID's tag for a SIC4310 chip
     *
     * @return true, if that tag is a SIC4310 chip
     */
    public boolean checkedUID() {
        byte[] uid = getUID();
        return !(uid == null || uid.length != 7) && uid[1] == SIC4310_UID;
    }

    @Override
    protected void setPeripheral() {
        mRegister = Register.getInstance(this);
        mGPIO = GPIO.getInstance(this);
        mPeripheral = Peripheral.getInstance(this);
        mUART = UART.getInstance(this);
    }

    /**
     * Get peripheral object for manage a peripheral of chip
     *
     * @return peripheral object
     */
    public Peripheral getPeripheral() {
        return mPeripheral;
    }


    /**
     * Get GPIO object for manage a GPIO of chip
     *
     * @return GPIO object
     */
    public GPIO getGPIO() {
        return mGPIO;
    }


    /**
     * Get UART object for manage a UART of chip
     *
     * @return UART object
     */
    public UART getUART() {
        return mUART;
    }
}
