/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.managements;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 27/Mar/2015
 */
public class TimerManager {

    private static final String TAG = TimerManager.class.getSimpleName();

    private static long time;
    private static long start;
    private static long spend;
    private static boolean run;

    public static void start() {
        time = System.currentTimeMillis();
        spend = 0;
        start = time;
        run = true;
    }

    public static void resume() {
        time = System.currentTimeMillis();
        if (!run) {
            start = time;
            run = true;
        }
    }

    public static void pause() {
        time = System.currentTimeMillis();
        if (run) {
            spend += time - start;
            run = false;
        }
    }

    public static long stop() {
        time = System.currentTimeMillis();
        long spd = spend;
        if (run) {
            run = false;
            spd += time - start;
        }
        spend = 0;
        return spd;
    }

    public static long tap() {
        if (run) {
            return System.currentTimeMillis() - start;
        } else {
            return -1;
        }
    }

    public static long stamp() {
        long stamp = System.currentTimeMillis() - time;
        time += stamp;
        return stamp;
    }

    public static long getSpend() {
        return spend;
    }

    public static void reset() {
        time = System.currentTimeMillis();
        spend = 0;
        start = time;
        run = false;
    }

}
