/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.mandatories;

import android.content.Context;
import android.content.Intent;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.NfcA;
import com.sic.module.nfc.Nfc;
import com.sic.module.utils.SICLog;
import com.sic.module.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NfcTypeA
extends Nfc {
    private static final String TAG = NfcTypeA.class.getName();
    private static final String[] TECH_LISTS = new String[]{NfcA.class.getName()};
    private static NfcTypeA instance;
    private final Context mContext;
    private NfcA nfcA;
    private int timeout = 618;
    private List<byte[]> transferData = new ArrayList<byte[]>();
    private List<byte[]> receiverData = new ArrayList<byte[]>();
    private boolean protection = true;
    protected byte response = (byte)125;

    protected NfcTypeA(Context context) {
        super(context, null, new String[][]{TECH_LISTS});
        this.mContext = context;
    }

    public static NfcTypeA getInstance(Context context) {
        if (instance == null) {
            instance = new NfcTypeA(context);
        }
        return instance;
    }

    @Override
    public boolean onTagFinding(Intent intent) {
        if (super.onTagFinding(intent)) {
            this.nfcA = NfcA.get((Tag)this.getTag());
            this.response = 0;
            return true;
        }
        return false;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public NfcA getRawNfcA() {
        return this.nfcA;
    }

    public boolean isTagExists() {
        try {
            if (this.nfcA.isConnected()) {
                this.nfcA.close();
            }
            this.nfcA.connect();
            if (this.protection) {
                this.nfcA.close();
            }
            return this.response != 125;
        }
        catch (Exception e) {
            this.response = (byte)125;
            return false;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.nfcA.setTimeout(timeout);
    }

    public boolean isProtection() {
        return this.protection;
    }

    public void setProtection(boolean protection) {
        this.protection = protection;
    }

    public void close() {
        this.protection = true;
        try {
            if (this.nfcA.isConnected()) {
                this.nfcA.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.response = (byte)125;
        }
    }

    public int addDataStream(byte[] ... buffer) {
        if (buffer == null || buffer.length == 0) {
            return -1;
        }
        Collections.addAll(this.transferData, buffer);
        return this.transferData.size() - 1;
    }

    public byte[][] getDataStream() {
        int index = 0;
        int size = this.receiverData.size();
        byte[][] result = new byte[size][];
        for (byte[] data : this.receiverData) {
            result[index++] = (byte[])data.clone();
        }
        return result;
    }

    public byte[] getDataStreamAt(int index) {
        if (index < 0 || index >= this.receiverData.size()) {
            return null;
        }
        return this.receiverData.get(index);
    }

    public byte[] getDataStreamAtLatestIndex() {
        int size = this.receiverData.size();
        if (size == 0) {
            return null;
        }
        return this.receiverData.get(this.receiverData.size() - 1);
    }

    public int getLatestIndexOfDataStream() {
        return this.receiverData.size() - 1;
    }

    public void clearDataStream() {
        this.transferData.clear();
        this.receiverData.clear();
    }

    public synchronized void stream() {
        block9: {
            byte[] recv = new byte[]{};
            this.receiverData.clear();
            this.response = (byte)127;
            try {
                if (!this.nfcA.isConnected()) {
                    this.nfcA.connect();
                    this.nfcA.setTimeout(this.timeout);
                }
                for (byte[] data : this.transferData) {
                    SICLog.wtf(TAG, "SEND[" + data.length + "]: " + Utils.parseByteArrayToHexString(data));
                    recv = this.nfcA.transceive(data);
                    this.receiverData.add(recv);
                    SICLog.wtf(TAG, "RECV[" + recv.length + "]: " + Utils.parseByteArrayToHexString(recv));
                }
                this.response = recv[0];
                if (this.protection) {
                    this.nfcA.close();
                }
            }
            catch (TagLostException e_lost) {
                this.response = (byte)125;
                SICLog.e(TAG, e_lost.getMessage());
            }
            catch (IOException | NullPointerException e_io_null) {
                this.response = (byte)126;
                if (e_io_null.getMessage() != null) {
                    SICLog.e(TAG, e_io_null.getMessage());
                } else {
                    e_io_null.printStackTrace();
                }
            }
            catch (Exception e) {
                this.response = (byte)15;
                if (e.getMessage() == null) break block9;
                SICLog.e(TAG, e.getMessage());
            }
        }
    }

    public synchronized byte[] autoTransceive(byte[] send_data) {
        byte[] recv = null;
        this.response = (byte)127;
        try {
            if (!this.nfcA.isConnected()) {
                this.nfcA.connect();
                this.nfcA.setTimeout(this.timeout);
            }
            SICLog.wtf(TAG, "SEND[" + send_data.length + "]: " + Utils.parseByteArrayToHexString(send_data));
            recv = this.nfcA.transceive(send_data);
            SICLog.wtf(TAG, "RECV[" + recv.length + "]: " + Utils.parseByteArrayToHexString(recv));
            this.response = recv[0];
            if (this.protection) {
                this.nfcA.close();
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                SICLog.e(TAG, e.getMessage());
                this.response = e.getMessage().contains("Transceive failed") ? (byte)126 : (byte)125;
            }
            this.response = (byte)125;
        }
        return recv;
    }

    public boolean isSendCompleted() {
        return this.response != 15 && this.response != 125 && this.response != 126;
    }
}

