/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips;

import android.content.Context;
import android.content.Intent;
import android.nfc.tech.NfcA;
import com.sic.module.nfc.tech.chips.sic43xx.DefRegister;
import com.sic.module.nfc.tech.mandatories.NfcTypeA;
import com.sic.module.nfc.tech.optionals.NfcTypeNdef;
import com.sic.module.utils.AppContext;

public class SIC43xx
extends NfcTypeA {
    private static final String TAG = SIC43xx.class.getName();
    private static final byte SIC43XX_UID = 57;
    protected NfcTypeNdef mNdef;
    private static SIC43xx instance;
    protected DefRegister mRegister = DefRegister.getInstance(this);

    protected SIC43xx(Context context) {
        super(context);
        this.mNdef = NfcTypeNdef.getInstance(context);
    }

    public static SIC43xx getInstance() {
        return SIC43xx.getInstance(AppContext.getInstance().getContext());
    }

    public static SIC43xx getInstance(Context context) {
        if (instance == null) {
            instance = new SIC43xx(context);
        }
        return instance;
    }

    @Override
    public boolean onTagFinding(Intent intent) {
        boolean found = false;
        if (super.onTagFinding(intent)) {
            this.mNdef.onTagFinding(this.getTag());
            found = true;
        }
        return found;
    }

    public boolean checkedUID() {
        byte[] uid = this.getUID();
        return uid != null && uid.length >= 4 && uid[0] == 57;
    }

    public DefRegister getRegister() {
        return this.mRegister;
    }

    public void resetTag() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NfcA nfcA = SIC43xx.this.getRawNfcA();
                try {
                    if (!nfcA.isConnected()) {
                        nfcA.connect();
                    }
                    nfcA.setTimeout(50);
                    nfcA.transceive(new byte[]{-80});
                    if (SIC43xx.this.isProtection()) {
                        nfcA.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public NfcTypeNdef getNdef() {
        return this.mNdef;
    }
}

