/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.utils;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 27/Mar/2015
 */
public enum Execution {

    INITIALIZE,             /*!< Initialize. */
    UPDATE,                 /*!< Update data. */
    HOLD,                   /*!< Paused data transmission. */
    COMPLETE,               /*!< Transmission complete. */
    FAILED,                 /*!< Transmission failed. */
    NEXT,                   /*!< To next state/transmission. */
    PREVIOUS,               /*!< To previous state/transmission. */
    CANCEL,                 /*!< Cancel task. */
    AUTHENTICATE,           /*!< Device is authenticated. */
    INSUFFICIENT,           /*!< Insufficient power. */
    UNSUPPORTED,            /*!< Unsupported device. */

    OK,                     /*!< OK */
    NOTAVAIL,               /*!< Requested any not available. */
    RXEMPTY,                /*!< No data in receiver. */
    TXFULL,                 /*!< Transmitter is full. */
    BUSOFF,                 /*!< Bus not available. */
    TIMEOUT,                /*!< Timeout. */

    ERR_RANGE,              /*!< Parameter out of range. */
    ERR_VALUE,              /*!< Parameter of incorrect value. */
    ERR_OVERFLOW,           /*!< Timer overflow. */
    ERR_MATH,               /*!< Overflow during evaluation. */
    ERR_COMMON,             /*!< Common error of a device. */

    DEVICE_ENABLED,         /*!< Device is enabled. */
    DEVICE_DISABLED,        /*!< Device is disabled. */
    DEVICE_BUSY,            /*!< Device is busy. */

    PARAM_MASK,             /*!< Invalid mask. */
    PARAM_MODE,             /*!< Invalid mode. */
    PARAM_INDEX,            /*!< Invalid index. */
    PARAM_DATA,             /*!< Invalid data. */
    PARAM_SIZE,             /*!< Invalid size. */
    PARAM_VALUE,            /*!< Invalid value. */
    PARAM_RANGE,            /*!< Invalid parameter's range or parameters' combination. */
    PARAM_LOW_VALUE,        /*!< Invalid value (LOW part). */
    PARAM_HIGH_VALUE,       /*!< Invalid value (HIGH part). */
    PARAM_ADDRESS,          /*!< Invalid address. */
    PARAM_PARITY,           /*!< Invalid parity. */
    PARAM_WIDTH,            /*!< Invalid width. */
    PARAM_LENGTH,           /*!< Invalid length. */
    PARAM_ADDRESS_TYPE,     /*!< Invalid address type. */
    PARAM_COMMAND_TYPE,     /*!< Invalid command type. */
    PARAM_COMMAND,          /*!< Invalid command. */
    PARAM_RECIPIENT,        /*!< Invalid recipient. */
    PARAM_BUFFER_COUNT,     /*!< Invalid buffer count. */
    PARAM_ID,               /*!< Invalid ID. */
    PARAM_GROUP,            /*!< Invalid group. */
    PARAM_CHIP_SELECT,      /*!< Invalid chip select. */
    PARAM_ATTRIBUTE_SET,    /*!< Invalid set of attributes. */
    PARAM_SAMPLE_COUNT,     /*!< Invalid sample count. */
    PARAM_CONDITION,        /*!< Invalid condition. */
    PARAM_TICKS             /*!< Invalid ticks parameter. */
}