/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.mandatories.mfcommands;

import com.sic.module.utils.Utils;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 26/Nov/2015
 */
public class EEPROM {

    /**
     * Gets the Read EEPROM protocol.
     *
     * @param address EEPROM address
     * @return byte array, data with Read EEPROM command
     */
    public static byte[] getPackage_Read(int address) {
        return new byte[]{(byte) 0x30, (byte) address};
    }

    /**
     * Gets the Write EEPROM protocol.
     *
     * @param address EEPROM address
     * @param data register data 4 bytes
     * @return byte array, data with Write EEPROM command
     */
    public static byte[] getPackage_Write(int address, byte[] data) {
        if (Utils.checkArraySize(data, 4, data.length)) {
            byte[] buffer = new byte[6];
            buffer[0] = (byte) 0xA2;
            buffer[1] = (byte) address;
            buffer[2] = data[0];
            buffer[3] = data[1];
            buffer[4] = data[2];
            buffer[5] = data[3];
            return buffer;
        }
        return null;
    }

    /**
     * Gets the Compatible Write EEPROM protocol.
     *
     * @param address EEPROM address
     * @param data register data 16 bytes (Some tag can be written 4 bytes only)
     * @return byte array, data with Compatible Write EEPROM command
     */
    public static byte[][] getPackage_CompatibleWrite(int address, byte[] data) {
        if (Utils.checkArraySize(data, 16, data.length)) {
            byte[][] buffer = new byte[2][];
            buffer[0] = new byte[2];
            buffer[1] = new byte[16];
            buffer[0][0] = (byte) 0xA0;
            buffer[0][1] = (byte) address;
            buffer[1] = data.clone();
            return buffer;
        }
        return null;
    }
}
