/*
 * Copyright (c) 2016 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc;

import android.content.Context;
import android.nfc.NfcAdapter;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 27/Mar/2015
 */
abstract class NfcWrapper {

    private static final String TAG = NfcWrapper.class.getSimpleName();

    /**
     * Check support building version of android SDK.
     *
     * @return null, if not supported.
     */
    public static NfcWrapper getInstance() {
        return NfcInteractions.LazyHolder.sInstance;
    }

    /**
     * Abstract function of NFC adapter.
     *
     * @param context application context
     * @return NFC adapter
     */
    public abstract NfcAdapter getAdapter(Context context);

    private static class NfcInteractions extends NfcWrapper {
        @Override
        public NfcAdapter getAdapter(Context context) {
            return NfcAdapter.getDefaultAdapter(context);
        }

        private static class LazyHolder {
            private static final NfcWrapper sInstance = new NfcInteractions();
        }
    }

}