/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import com.sic.module.utils.AppContext;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Utils {
    public static final byte BIT_7 = -128;
    public static final byte BIT_6 = 64;
    public static final byte BIT_5 = 32;
    public static final byte BIT_4 = 16;
    public static final byte BIT_3 = 8;
    public static final byte BIT_2 = 4;
    public static final byte BIT_1 = 2;
    public static final byte BIT_0 = 1;
    private static final String TAG = Utils.class.getName();
    private static final String TAG_DIALOG_FRAGMENT = "dialog_fragment";
    private static final Handler mHandler = new Handler(Looper.getMainLooper());
    private static Utils instance;
    private final Context mContext;

    private Utils(Context context) {
        this.mContext = context;
    }

    private Utils() {
        this(AppContext.getInstance().getContext());
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static Utils getInstance(Context context) {
        if (instance == null) {
            instance = new Utils(context);
        }
        return instance;
    }

    public static String parseDecimalStringToHexString(String string) {
        return String.format("%X ", new BigInteger(string.getBytes()));
    }

    public static byte[] parseASCIIStringToByteArray(String ascii) {
        int length = ascii.length();
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = (byte)ascii.charAt(i);
        }
        return b;
    }

    public static byte[] parseHexStringToByteArray(String sarray) {
        ArrayList<String> separated = new ArrayList<String>();
        for (int index = 0; index < sarray.length(); index += 2) {
            separated.add(sarray.substring(index, Math.min(index + 2, sarray.length())));
        }
        byte[] b = new byte[separated.size()];
        for (int i = 0; i < separated.size(); ++i) {
            try {
                b[i] = (byte)Integer.parseInt((String)separated.get(i), 16);
                continue;
            }
            catch (NumberFormatException e) {
                b[i] = -1;
            }
        }
        return b;
    }

    public static byte[] parseStringToByteArray(String sarray, int radix) {
        ArrayList<String> separated = new ArrayList<String>();
        int width = (int)Math.ceil(Math.log10(255.0) / Math.log10(radix));
        for (int index = 0; index < sarray.length(); index += width) {
            String s = sarray.substring(index, Math.min(index + width, sarray.length()));
            if (Integer.parseInt(s, radix) > 255) {
                sarray = sarray.substring(0, index) + "0" + sarray.substring(index, sarray.length());
                s = sarray.substring(index, Math.min(index + width, sarray.length()));
            }
            separated.add(s);
        }
        byte[] b = new byte[separated.size()];
        for (int i = 0; i < separated.size(); ++i) {
            try {
                b[i] = (byte)Integer.parseInt((String)separated.get(i), radix);
                continue;
            }
            catch (NumberFormatException e) {
                b[i] = -1;
            }
        }
        return b;
    }

    public static byte[] parseIntegerToByteArray(int intad) {
        String HexStr = Integer.toHexString(intad);
        return Utils.parseHexStringToByteArray(HexStr);
    }

    public static byte[] parseIntegerToByteArray(int intad, int length) {
        String HexStr = Integer.toHexString(intad);
        length <<= 1;
        while (HexStr.length() < length) {
            HexStr = "0" + HexStr;
        }
        if (HexStr.length() > length) {
            HexStr = HexStr.substring(HexStr.length() - length);
        }
        return Utils.parseHexStringToByteArray(HexStr);
    }

    public static String parseByteToHexString(byte bytead) {
        return ("" + String.format("%02x", bytead & 0xFF)).toUpperCase();
    }

    public static String parseByteArrayToASCIIString(byte[] barray) {
        StringBuilder strBuilder = new StringBuilder();
        for (byte aBarray : barray) {
            strBuilder.append((char)aBarray);
        }
        return strBuilder.toString();
    }

    public static String parseByteArrayToHexString(byte[] barray) {
        StringBuilder hexString = new StringBuilder("");
        if (barray == null) {
            return "";
        }
        for (byte b : barray) {
            hexString.append(String.format("%02x", b & 0xFF));
        }
        return hexString.toString();
    }

    public static String parseByteArrayToString(byte[] barray, int radix) {
        StringBuilder string = new StringBuilder("");
        int width = (int)Math.ceil(Math.log10(255.0) / Math.log10(radix));
        for (byte b : barray) {
            String temp = Integer.toString(b & 0xFF, radix);
            while (temp.length() % width != 0) {
                temp = "0" + temp;
            }
            string.append(temp);
        }
        return string.toString();
    }

    public static String getDateAndTimeString() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("   dd/MM/yyyy       HH:mm:ss    ", Locale.US);
        return format.format(date);
    }

    public static String getTimeString() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss", Locale.US);
        return format.format(date);
    }

    public static String getCapitalizeFirstLetter(String original) {
        if (original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1).toLowerCase();
    }

    public static byte[] concatenateByteArray(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }

    public static void scrollAmountTextView(TextView view) {
        try {
            int scrollAmount = view.getLayout().getLineTop(view.getLineCount()) - view.getHeight();
            if (scrollAmount > 0) {
                view.scrollTo(0, scrollAmount);
            } else {
                view.scrollTo(0, 0);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static String getOrdinal(int packetNumber) {
        String ordinal;
        if (packetNumber / 10 % 10 == 1) {
            ordinal = packetNumber + "th";
        } else {
            switch (packetNumber % 10) {
                case 1: {
                    ordinal = packetNumber + "st";
                    break;
                }
                case 2: {
                    ordinal = packetNumber + "nd";
                    break;
                }
                case 3: {
                    ordinal = packetNumber + "rd";
                    break;
                }
                default: {
                    ordinal = packetNumber + "th";
                }
            }
        }
        return ordinal;
    }

    public static byte checkSum(byte[] input) {
        byte sum = 0;
        for (int i = 0; i < input.length - 1; ++i) {
            sum = (byte)(sum ^ input[i]);
        }
        return sum;
    }

    public static byte checkSum(byte[] data, int start, int length) {
        byte crc = 0;
        if (data == null) {
            return 0;
        }
        if (start < 0 || length < 1 || start + length > data.length + 1) {
            return 0;
        }
        for (int i = start; i < start + length - 1; ++i) {
            crc = (byte)(crc ^ data[i]);
        }
        return crc;
    }

    public static Spannable toSpannable(String text) {
        return new SpannableString((CharSequence)text);
    }

    public static Spannable setSpannable(Spannable text, int color) {
        text.setSpan((Object)new ForegroundColorSpan(color), 0, text.length(), 33);
        return text;
    }

    public static Spannable setSpannable(Spannable fulltext, String subtext, int color) {
        int index = fulltext.toString().indexOf(subtext);
        if (index < 0) {
            return fulltext;
        }
        fulltext.setSpan((Object)new ForegroundColorSpan(color), index, index + subtext.length(), 33);
        return fulltext;
    }

    public static Spannable setSpannable(Spannable text, int index, int length, int color) {
        if (index + length > text.length() || index < 0 || length < 0) {
            return text;
        }
        text.setSpan((Object)new ForegroundColorSpan(color), index, index + length, 33);
        return text;
    }

    public static boolean checkArraySize(byte[] data, int min_size, int max_size) {
        return data != null && min_size >= 0 && data.length >= min_size && data.length <= max_size;
    }

    public static byte[][] chunkSplit(byte[] data, int size) {
        if (Utils.checkArraySize(data, 1, data.length)) {
            int dalen = data.length;
            int maxlen = (int)Math.ceil((double)dalen / (double)size);
            byte[][] buffer = new byte[maxlen--][];
            for (int i = 0; i < maxlen; ++i) {
                buffer[i] = new byte[size];
                System.arraycopy(data, i * size, buffer[i], 0, size);
            }
            if (dalen % size > 0) {
                size = dalen % size;
            }
            buffer[maxlen] = new byte[size];
            System.arraycopy(data, dalen - size, buffer[maxlen], 0, size);
            return buffer;
        }
        return null;
    }

    public static byte[] getPackageLimited(byte cmd, byte[] data, int size) {
        if (data == null) {
            return null;
        }
        int length = Math.min(size, data.length);
        byte[] buffer = new byte[length + 1];
        buffer[0] = cmd;
        System.arraycopy(data, 0, buffer, 1, length);
        return buffer;
    }

    public static byte[][] getPackageSplit(byte cmd, byte[][] data, int size) {
        return Utils.getPackageSplit(cmd, cmd, data, size);
    }

    public static byte[][] getPackageSplit(byte cmd, byte lastcmd, byte[][] data, int size) {
        ArrayList<byte[]> buffer = new ArrayList<byte[]>();
        for (byte[] each : data) {
            byte[] temp;
            if (!Utils.checkArraySize(each, 1, each.length)) continue;
            int dalen = each.length;
            int localSize = size;
            int maxlen = (int)Math.ceil((double)dalen / (double)localSize) - 1;
            for (int i = 0; i < maxlen; ++i) {
                temp = new byte[localSize + 1];
                temp[0] = cmd;
                System.arraycopy(each, i * localSize, temp, 1, localSize);
                buffer.add(temp);
            }
            if (dalen % localSize > 0) {
                localSize = dalen % localSize;
            }
            temp = new byte[localSize + 1];
            temp[0] = lastcmd;
            System.arraycopy(each, dalen - localSize, temp, 1, localSize);
            buffer.add(temp);
        }
        byte[][] array = new byte[buffer.size()][];
        return (byte[][])buffer.toArray((T[])array);
    }

    public static synchronized Handler postDelayed(Runnable runnable, long delay) {
        mHandler.postDelayed(runnable, delay);
        return mHandler;
    }

    public static synchronized void postCancelled() {
        if (mHandler != null) {
            mHandler.removeCallbacksAndMessages(null);
        }
    }

    public String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
    }

    public String getVersionName() {
        try {
            PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (Exception e) {
            return "1.0";
        }
    }

    public int dpToPx(float dp) {
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        return (int)px;
    }

    public List<ApplicationInfo> getInstalledApplication() {
        PackageManager packageManager = this.mContext.getPackageManager();
        List apps = packageManager.getInstalledApplications(0);
        Collections.sort(apps, new ApplicationInfo.DisplayNameComparator(packageManager));
        return apps;
    }
}

