/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.managements;

public class TimerManager {
    private static final String TAG = TimerManager.class.getSimpleName();
    private static long time;
    private static long start;
    private static long spend;
    private static boolean run;

    public static void start() {
        time = System.currentTimeMillis();
        spend = 0L;
        start = time;
        run = true;
    }

    public static void resume() {
        time = System.currentTimeMillis();
        if (!run) {
            start = time;
            run = true;
        }
    }

    public static void pause() {
        time = System.currentTimeMillis();
        if (run) {
            spend += time - start;
            run = false;
        }
    }

    public static long stop() {
        time = System.currentTimeMillis();
        long spd = spend;
        if (run) {
            run = false;
            spd += time - start;
        }
        spend = 0L;
        return spd;
    }

    public static long tap() {
        if (run) {
            return System.currentTimeMillis() - start;
        }
        return -1L;
    }

    public static long stamp() {
        long stamp = System.currentTimeMillis() - time;
        time += stamp;
        return stamp;
    }

    public static long getSpend() {
        return spend;
    }

    public static void reset() {
        time = System.currentTimeMillis();
        spend = 0L;
        start = time;
        run = false;
    }
}

