/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.managements;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import com.sic.module.utils.AppContext;
import com.sic.module.utils.SICLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileManager {
    public static final String DEFAULT_FOLDER_WORKSPACE = Environment.getExternalStorageDirectory().getAbsolutePath() + "/SIC/";
    public static final String DEFAULT_FOLDER_LOG = DEFAULT_FOLDER_WORKSPACE + "log/";
    public static final String DEFAULT_FOLDER_TEMP = DEFAULT_FOLDER_WORKSPACE + "tmp/";
    private static final String TAG = FileManager.class.getSimpleName();
    private static FileManager instance;
    private final Context mContext;

    private FileManager(Context context) {
        this.mContext = context;
    }

    public static FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager(AppContext.getInstance().getContext());
        }
        return instance;
    }

    public static FileManager getInstance(Context context) {
        if (instance == null) {
            instance = new FileManager(context);
        }
        return instance;
    }

    public boolean isFileExistAndNotEmpty(String pathFile) {
        if (pathFile == null) {
            return false;
        }
        File f = new File(pathFile);
        long lengthInBytes = f.length();
        SICLog.i(TAG, pathFile + " length in bytes: " + lengthInBytes);
        return lengthInBytes > 100L;
    }

    public boolean isFolderExist(String pathFolder) {
        File f = new File(pathFolder);
        return f.exists() && f.isDirectory();
    }

    public boolean createFolder(String pathFolder) {
        File f = new File(pathFolder);
        return f.mkdirs();
    }

    public boolean writeFromResourceId(String pathfile, int resid) {
        FileOutputStream outputStream;
        if (this.isFileExistAndNotEmpty(pathfile)) {
            return false;
        }
        byte[] buffer = new byte[1024];
        File file = new File(pathfile);
        InputStream inputStream = this.mContext.getResources().openRawResource(resid);
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            int length;
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
            ((OutputStream)outputStream).close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteFile(String pathFile) {
        File f = new File(pathFile);
        boolean isDeleted = f.delete();
        SICLog.i(TAG, "deleteing: " + pathFile + " isdeleted: " + isDeleted);
        return isDeleted;
    }

    public String getFileNameFromFilePath(String filePath) {
        int index = filePath.lastIndexOf("/");
        return filePath.substring(index + 1, filePath.length());
    }

    public Bitmap getBitmapFromImageFile(File file, int width, int height) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)o);
            int scale = 1;
            while (o.outWidth / scale / 2 >= width && o.outHeight / scale / 2 >= height) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public int getFileTypeFromFile(String filePath) {
        int type = filePath.indexOf(46);
        if (type < 0) {
            return FileType.no_ext.getCode();
        }
        String ext = filePath.substring(type + 1).toLowerCase();
        for (FileType fileType : FileType.values()) {
            if (!ext.contains(fileType.getType())) continue;
            return fileType.getCode();
        }
        return FileType.Unknown.getCode();
    }

    public static enum FileType {
        Image("IMAGE", 16),
        raw("raw", 16),
        jpg("jpg", 17),
        jpeg("jpeg", 17),
        png("png", 18),
        bmp("bmp", 19),
        gif("gif", 20),
        tiff("tiff", 21),
        ico("ico", 22),
        Text("TEXT", 32),
        no_ext("", 32),
        txt("txt", 33),
        doc("doc", 34),
        docx("docx", 35),
        hex("hex", 47),
        s19("s19", 46),
        Audio("AUDIO", 48),
        wav("wav", 48),
        mp3("mp3", 49),
        wma("wma", 50),
        ogg("ogg", 51),
        ac3("ac3", 52),
        aac("aac", 53),
        ndef("mndef", 68),
        Unknown("UNKNOWN", 0);

        private final String type;
        private final int code;

        private FileType(String type, int code) {
            this.type = type;
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String getType() {
            return this.type;
        }
    }
}

