/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.utils;

import android.util.Log;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.1
 * @since 11/Jan/2016
 */
public final class SICLog {

    private static final String TAG = SICLog.class.getSimpleName();

    /**
     * Priority constant for the println method;
     */
    private static boolean SHOW_LOG = false;

    /**
     * Stes show log.
     *
     * @param enabled true or false
     */
    public static void setShowLogEnabled(boolean enabled) {
        SHOW_LOG = enabled;
    }
    /**
     * Send a {VERBOSE} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void v(String tag, String msg) {
        if (SHOW_LOG)
            Log.v(tag, msg);
    }

    /**
     * Send a {DEBUG} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void d(String tag, String msg) {
        if (SHOW_LOG)
            Log.d(tag, msg);
    }

    /**
     * Send an {INFO} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void i(String tag, String msg) {
        if (SHOW_LOG)
            Log.i(tag, msg);
    }

    /**
     * Send a {WARN} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void w(String tag, String msg) {
        if (SHOW_LOG)
            Log.w(tag, msg);
    }

    /**
     * Send an {ERROR} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void e(String tag, String msg) {
        if (SHOW_LOG)
            Log.e(tag, msg);
    }

    /**
     * Send an {ASSERT} log message.
     *
     * @param tag Used to identify the source of a log message. It usually
     *            identifies the class or activity where the log call occurs.
     * @param msg The message you would like logged.
     */
    public static void wtf(String tag, String msg) {
        if (SHOW_LOG)
            Log.wtf(tag, msg);
    }

}
