/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.utils;

import android.util.Log;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.1
 * @since 25/Nov/2015
 */
public class Buffer {

    private static final String TAG = Buffer.class.getSimpleName();
    private final int length;
    private final byte[] data;
    private final boolean[] sync;

    public Buffer(int length) {
        this.length = length;
        data = new byte[length];
        sync = new boolean[length];
    }

    public static Buffer newInstance(int length) {
        return new Buffer(length);
    }

    public void set(int index, int data) {
        if (index >= length) {
            return;
        }
        this.data[index] = (byte) data;
        this.sync[index] = true;
    }

    public void set(byte[] index, byte[] data) {
        if (index.length != data.length) {
            Log.e(TAG, "size is mismatch");
            return;
        }
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.data[index[i]] = data[i];
            this.sync[index[i]] = true;
        }
    }

    public void set(byte[]... dataBytes) {
        byte index, data;
        for (byte[] dataArrays : dataBytes) {
            if (dataArrays.length != 2) {
                Log.e(TAG, "size is mismatch");
                continue;
            }
            index = dataArrays[0];
            data = dataArrays[1];
            this.data[index] = data;
            this.sync[index] = true;
        }
    }

    public Byte get(int index) {
        if (index >= length) {
            return null;
        }
        if (!sync[index]) {
            return null;
        }
        return data[index];
    }

    public void unSync(int index) {
        sync[index] = false;
        data[index] = 0x00;
    }

    public boolean isSync() {
        for (boolean s : sync) {
            if (!s) {
                return false;
            }
        }
        return true;
    }

    public boolean isSyncAt(int index) {
        return sync[index];
    }
}
