package com.sic.module.nfc.tech.interfaces;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 26/Nov/2015
 */
public abstract class IDevice implements IDefine {

    private static final String TAG = IDevice.class.getSimpleName();

    protected final IRegister mRegister;

    protected IDevice(IRegister register) {
        super();
        mRegister = register;
        setRegisterAddress();
        setDefaultBit();
    }

    protected abstract void setRegisterAddress();

    protected abstract void setDefaultBit();
}
