/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.sic43xx;

import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.interfaces.IRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 16/Oct/2015
 */
public class DefRegister extends IRegister {

    private static final String TAG = DefRegister.class.getSimpleName();

    private static DefRegister instance;
    public static final int REGISTER_PAGE = 0x40;

    protected DefRegister(SIC43xx sic43xx) {
        super(sic43xx);
    }

    public static DefRegister getInstance(SIC43xx sic43xx) {
        if (instance == null)
            instance = new DefRegister(sic43xx);
        return instance;
    }

    @Override
    protected int getRegisterPage() {
        return REGISTER_PAGE;
    }


}
