package com.sic.module.nfc.tech.chips.sic431x;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 2/Dec/2015
 */
public class Flag {
    // Response Flag (RF - UART, RF - RegPage)
    public static final byte B_ACK = 0x1A;
    public static final byte B_NAK = (byte) 0x80;
    // Data Bit Clear Flag
    public static final byte C_FLUSH_TX_FIFO = 0x01;
    public static final byte C_FLUSH_RX_FIFO = 0x02;
    public static final byte C_CLEAR_PWR_LOW_FLAG = 0x04;
    public static final byte C_CLEAR_XVDD_DROP_FLAG = 0x08;
    public static final byte C_CLEAR_OSC_STOP_FLAG = 0x10;
    // Response NACK
    public static final byte B_NAK_DL_FIFO_OVF = 0x01;
    public static final byte B_NAK_UL_FIFO_EMP = 0x02;
    public static final byte B_NAK_UL_FIFO_OVF = 0x04;
    public static final byte B_NAK_RSPW_LOW = 0x08;
    public static final byte B_NAK_XVDD_DROP = 0x10;
    public static final byte B_NAK_UART_FAIL = 0x20;

    public static String getName(byte flag) {
        switch (flag) {
            case B_ACK:
                return "B_ACK";

            default:
                String rtFlag = "";
                byte cFlag = B_NAK;

                if ((flag & cFlag) == cFlag) {
                    cFlag = B_NAK_DL_FIFO_OVF;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "DL_FIFO_OVF";
                    }

                    cFlag = B_NAK_UL_FIFO_EMP;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "UL_FIFO_EMP";
                    }

                    cFlag = B_NAK_UL_FIFO_OVF;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "UL_FIFO_OVF";
                    }

                    cFlag = B_NAK_RSPW_LOW;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "PWR_LOW";
                    }

                    cFlag = B_NAK_XVDD_DROP;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "XVDD_DROP";
                    }

                    cFlag = B_NAK_UART_FAIL;
                    if ((flag & cFlag) == cFlag) {
                        if (!rtFlag.isEmpty()) {
                            rtFlag += "/";
                        }
                        rtFlag += "UART_FAIL";
                    }

                    return rtFlag;
                } else {
                    return com.sic.module.nfc.Flag.getName(flag);
                }
        }
    }
}
