/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips;

import android.content.Context;
import android.content.Intent;
import android.nfc.tech.NfcA;

import com.sic.module.nfc.tech.chips.sic43xx.DefRegister;
import com.sic.module.nfc.tech.mandatories.NfcTypeA;
import com.sic.module.nfc.tech.optionals.NfcTypeNdef;
import com.sic.module.utils.AppContext;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.2
 * @since 25/Nov/2015
 */
public class SIC43xx extends NfcTypeA {

    private static final String TAG = SIC43xx.class.getName();
    private static final byte SIC43XX_UID = 0x39;
    protected NfcTypeNdef mNdef;

    private static SIC43xx instance;
    protected DefRegister mRegister;

    protected SIC43xx(Context context) {
        super(context);
        mRegister = DefRegister.getInstance(this);
        mNdef = NfcTypeNdef.getInstance(context);
    }

    public static SIC43xx getInstance() {
        return getInstance(AppContext.getInstance().getContext());
    }

    public static SIC43xx getInstance(Context context) {
        if (instance == null) {
            instance = new SIC43xx(context);
        }
        return instance;
    }

    @Override
    public boolean onTagFinding(Intent intent) {
        boolean found = false;
        if (super.onTagFinding(intent)) {
            mNdef.onTagFinding(getTag());
            found = true;
        }
        return found;
    }

    /**
     * Checks a UID's tag for a SIC's chip
     *
     * @return true, if that tag is a SIC's chip
     */
    public boolean checkedUID() {
        byte[] uid = getUID();
        return !(uid == null || uid.length < 4) && uid[0] == SIC43XX_UID;
    }

    /**
     * Get register object for manage the register's chip
     *
     * @return default register
     */
    public DefRegister getRegister() {
        return mRegister;
    }

    /**
     *
     */
    public void resetTag() {
        new Thread(new Runnable() {

            @Override
            public void run() {
                NfcA nfcA = getRawNfcA();
                try {
                    if (!nfcA.isConnected()) {
                        nfcA.connect();
                    }
                    nfcA.setTimeout(50);
                    nfcA.transceive(new byte[]{(byte) 0xB0});
                    if (isProtection()) {
                        nfcA.close();
                    }
                } catch (Exception ignored) {
                }
            }
        }).start();
    }

    public NfcTypeNdef getNdef() {
        return mNdef;
    }
}