/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.mandatories;

import android.content.Context;
import android.content.Intent;
import android.nfc.Tag;
import android.nfc.tech.NfcA;
import com.sic.module.nfc.Nfc;
import com.sic.module.nfc.tech.interfaces.ICommand;
import com.sic.module.nfc.tech.mandatories.MFCommand;
import com.sic.module.utils.SICLog;
import com.sic.module.utils.Utils;
import java.io.IOException;

public class NfcTypeA
extends Nfc {
    private static final String TAG = NfcTypeA.class.getName();
    private static final String[] TECH_LISTS = new String[]{NfcA.class.getName()};
    private static NfcTypeA instance;
    private final Context mContext;
    private NfcA nfcA;
    private boolean criticalState = false;
    private boolean e2CriticalState = false;
    private boolean commandCriticalState = false;
    private int timeout = 500;
    private byte responseFlag;
    private byte[] receiveData;

    private NfcTypeA(Context context) {
        super(context, null, new String[][]{TECH_LISTS});
        this.mContext = context;
    }

    public static NfcTypeA getInstance(Context context) {
        if (instance == null) {
            instance = new NfcTypeA(context);
        }
        return instance;
    }

    public static String getFlagName(byte flag) {
        switch (flag) {
            case 10: {
                return "NFC ACK";
            }
            case 15: {
                return "NFC NAK";
            }
            case 126: {
                return "Exception";
            }
            case 125: {
                return "Tag lost";
            }
        }
        return " - ";
    }

    public Context getContext() {
        return this.mContext;
    }

    public boolean isConnected() {
        try {
            this.nfcA.isConnected();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean onTagFinding(Intent intent) {
        if (super.onTagFinding(intent)) {
            this.nfcA = NfcA.get((Tag)this.getTag());
            return true;
        }
        return false;
    }

    public synchronized byte[] transceive(byte[] data) throws IOException {
        return this.nfcA.transceive(data);
    }

    public void connect() throws IOException {
        this.nfcA.close();
        this.nfcA.connect();
        this.nfcA.setTimeout(this.timeout);
    }

    public void close() throws IOException {
        this.nfcA.close();
    }

    public synchronized byte[] autoTransceive(byte[] send_data) {
        try {
            while (this.criticalState) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.criticalState = true;
        byte[] receive_data = null;
        try {
            this.connect();
            receive_data = this.nfcA.transceive(send_data);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                SICLog.e(TAG, e.getMessage());
                this.responseFlag = e.getMessage().contains("Transceive failed") ? (byte)126 : (byte)125;
            }
            this.responseFlag = (byte)125;
        }
        this.criticalState = false;
        return receive_data;
    }

    public synchronized byte[][] autoTransceive(byte[] ... multi_data) {
        try {
            while (this.criticalState) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.criticalState = true;
        int index = 0;
        byte[][] receive_data = new byte[multi_data.length][];
        try {
            this.connect();
            for (byte[] data : multi_data) {
                receive_data[index++] = this.nfcA.transceive(data);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                SICLog.e(TAG, e.getMessage());
                this.responseFlag = e.getMessage().contains("Transceive failed") ? (byte)126 : (byte)125;
            }
            this.responseFlag = (byte)125;
        }
        this.criticalState = false;
        return receive_data;
    }

    public byte[] commandTransceive(ICommand command, byte[] data) {
        byte[][] recv = this.commandTransceive(command, new byte[][]{data});
        if (recv == null || recv.length == 0) {
            return null;
        }
        return recv[0];
    }

    public byte[][] commandTransceive(ICommand command, byte[] ... multi_data) {
        Object data;
        int n;
        byte[][] receive = null;
        byte[][] buffer = new byte[multi_data.length][];
        if (!this.isConnected() || !this.isNfcTag()) {
            SICLog.e(TAG, "Block data transmission");
            this.commandCriticalState = false;
            return null;
        }
        if (buffer.length == 0) {
            SICLog.i(TAG, "Please check data input.");
            this.commandCriticalState = false;
            return null;
        }
        try {
            while (this.commandCriticalState) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.commandCriticalState = true;
        int index = 0;
        byte[][] byArray = multi_data;
        int n2 = byArray.length;
        for (n = 0; n < n2; ++n) {
            data = byArray[n];
            buffer[index] = command.getBuffer((byte[])data);
            if (buffer[index] == null) {
                SICLog.i(TAG, "Buffer[-]: ");
            } else {
                SICLog.i(TAG, "Buffer[" + buffer[index].length + "]: " + Utils.parseByteArrayToHexString(buffer[index]));
            }
            ++index;
        }
        this.resetFlag();
        this.e2CriticalState = false;
        try {
            Object buffer_address;
            if (command.equals(MFCommand.COMPATIBILITY_WRITE_EEPROM)) {
                this.e2CriticalState = true;
                buffer_address = MFCommand.COMPATIBILITY_WRITE_EEPROM_ADDRESS.getBuffer(multi_data[0]);
                byte[] buffer_data = MFCommand.COMPATIBILITY_WRITE_EEPROM_DATA.getBuffer(multi_data[1]);
                receive = this.autoTransceive(new byte[][]{buffer_address, buffer_data});
            } else if (command.equals(MFCommand.WRITE_EEPROM)) {
                this.e2CriticalState = true;
                receive = this.autoTransceive(buffer);
            } else if (command.equals(MFCommand.READ_EEPROM)) {
                this.e2CriticalState = true;
                receive = this.autoTransceive(buffer);
            } else {
                receive = this.autoTransceive(buffer);
            }
            buffer_address = receive;
            int n3 = ((byte[])buffer_address).length;
            for (n = 0; n < n3; ++n) {
                data = buffer_address[n];
                if (data != null && ((byte[])data).length > 0) {
                    SICLog.i(TAG, "Receive[" + ((byte[])data).length + "]: " + Utils.parseByteArrayToHexString(data));
                    continue;
                }
                SICLog.i(TAG, "Receive[0]: NULL");
            }
            this.checkLatestReceiver(receive);
        }
        catch (Exception e) {
            this.responseFlag = (byte)125;
            SICLog.e(TAG, "NFC communicate exception: " + e.getLocalizedMessage());
        }
        this.commandCriticalState = false;
        return receive;
    }

    private void checkLatestReceiver(byte[] ... buffer) {
        int lastData = buffer.length - 1;
        if (lastData == -1) {
            SICLog.e(TAG, "Data receiver is null pointer exception.");
            this.responseFlag = (byte)126;
            this.receiveData = new byte[0];
            return;
        }
        this.receiveData = new byte[buffer[lastData].length];
        if (this.e2CriticalState) {
            this.responseFlag = (byte)127;
            if (this.receiveData.length == 1) {
                this.responseFlag = buffer[lastData][0];
                this.receiveData[0] = buffer[lastData][0];
            } else if (this.receiveData.length > 1) {
                System.arraycopy(buffer[lastData], 0, this.receiveData, 0, this.receiveData.length);
            }
            this.e2CriticalState = false;
        } else if (this.receiveData.length > 1) {
            this.responseFlag = buffer[lastData][0];
            System.arraycopy(buffer[lastData], 0, this.receiveData, 0, this.receiveData.length);
        } else {
            this.responseFlag = (byte)125;
        }
    }

    private void resetFlag() {
        this.responseFlag = (byte)124;
    }

    public boolean isSendCompleted() {
        return this.responseFlag != 15 && this.responseFlag != 125 && this.responseFlag != 126 && this.isConnected();
    }

    protected boolean checkCriticalState() {
        return this.criticalState | this.commandCriticalState;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.nfcA != null) {
            this.nfcA.setTimeout(timeout);
        }
    }

    public byte getResponseFlag() {
        return this.responseFlag;
    }

    public byte[] getReceiverData() {
        return this.receiveData;
    }

    public byte[] getAtqa() {
        return this.nfcA.getAtqa();
    }

    public int getMaxTransceiveLength() {
        return this.nfcA.getMaxTransceiveLength();
    }

    public short getSak() {
        return this.nfcA.getSak();
    }

    public NfcA getRawNfcA() {
        return this.nfcA;
    }
}

