/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.mandatories;

import com.sic.module.nfc.tech.interfaces.ICommand;

public enum MFCommand implements ICommand
{
    AUTHENTICATION(4110){

        @Override
        public byte[] getBuffer(byte[] unused) {
            return new byte[]{0};
        }
    }
    ,
    AUTHENTICATION_ACCESS(4111){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{96, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    AUTHENTICATION_ACCESS_OPTIONAL(4112){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{97, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    AUTHENTICATION_ENCRYPTED_DATA(4113){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 8, data.length)) {
                byte[] buffer = new byte[8];
                System.arraycopy(data, 0, buffer, 0, 8);
                return buffer;
            }
            return null;
        }
    }
    ,
    READ_EEPROM(4120){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{48, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    WRITE_EEPROM(4130){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 5, data.length)) {
                byte[] buffer = new byte[6];
                buffer[0] = -94;
                System.arraycopy(data, 0, buffer, 1, 5);
                return buffer;
            }
            return null;
        }
    }
    ,
    COMPATIBILITY_WRITE_EEPROM(4140){

        @Override
        public byte[] getBuffer(byte[] unused) {
            return new byte[]{0};
        }
    }
    ,
    COMPATIBILITY_WRITE_EEPROM_ADDRESS(4141){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-96, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    COMPATIBILITY_WRITE_EEPROM_DATA(4142){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 16, data.length)) {
                byte[] buffer = new byte[16];
                System.arraycopy(data, 0, buffer, 0, 16);
                return buffer;
            }
            return null;
        }
    }
    ,
    RESTORE(4150){

        @Override
        public byte[] getBuffer(byte[] unused) {
            return new byte[]{0};
        }
    }
    ,
    RESTORE_ADDRESS(4151){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-62, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    RESTORE_DATA(4152){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 4, data.length)) {
                byte[] buffer = new byte[4];
                System.arraycopy(data, 0, buffer, 0, 4);
                return buffer;
            }
            return null;
        }
    }
    ,
    INCREMENT(4160){

        @Override
        public byte[] getBuffer(byte[] unused) {
            return new byte[]{0};
        }
    }
    ,
    INCREMENT_ADDRESS(4161){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-63, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    INCREMENT_DATA(4162){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 4, data.length)) {
                byte[] buffer = new byte[4];
                System.arraycopy(data, 0, buffer, 0, 4);
                return buffer;
            }
            return null;
        }
    }
    ,
    DECREMENT(4170){

        @Override
        public byte[] getBuffer(byte[] unused) {
            return new byte[]{0};
        }
    }
    ,
    DECREMENT_ADDRESS(4171){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-64, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    DECREMENT_DATA(4172){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 4, data.length)) {
                byte[] buffer = new byte[4];
                System.arraycopy(data, 0, buffer, 0, 4);
                return buffer;
            }
            return null;
        }
    }
    ,
    TRANSFER(4180){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{48, data[0]};
                return buffer;
            }
            return null;
        }
    };

    private final int commandID;

    private MFCommand(int commandID) {
        this.commandID = commandID;
    }

    @Override
    public int getID() {
        return this.commandID;
    }

    @Override
    public abstract byte[] getBuffer(byte[] var1);

    @Override
    public boolean checkDataBuffer(byte[] data, int min_size, int max_size) {
        return data != null && min_size >= 0 && data.length >= min_size && data.length <= max_size;
    }
}

