/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.interfaces;

public interface IRegister {
    public static final int BIT_7 = Bit.access$000(Bit.BIT_7);
    public static final int BIT_6 = Bit.access$000(Bit.BIT_6);
    public static final int BIT_5 = Bit.access$000(Bit.BIT_5);
    public static final byte BIT_4 = Bit.access$000(Bit.BIT_4);
    public static final byte BIT_3 = Bit.access$000(Bit.BIT_3);
    public static final byte BIT_2 = Bit.access$000(Bit.BIT_2);
    public static final byte BIT_1 = Bit.access$000(Bit.BIT_1);
    public static final byte BIT_0 = Bit.access$000(Bit.BIT_0);

    public static enum Bit {
        BIT_7(128),
        BIT_6(64),
        BIT_5(32),
        BIT_4(16),
        BIT_3(8),
        BIT_2(4),
        BIT_1(2),
        BIT_0(1);

        private final byte bit;

        private Bit(int bit) {
            this.bit = (byte)(bit & 0xFF);
        }

        public static byte parseBit() {
            return 0;
        }

        public static byte parseBit(Bit ... bits) {
            byte sum = 0;
            for (Bit bit : bits) {
                sum = (byte)(sum | bit.getByte());
            }
            return sum;
        }

        public static byte parseBit(int ... bits) {
            byte sum = 0;
            for (int bit : bits) {
                sum = (byte)(sum | (int)Math.pow(2.0, bit) & 0xFF);
            }
            return sum;
        }

        public byte getByte() {
            return this.bit;
        }

        static /* synthetic */ byte access$000(Bit x0) {
            return x0.bit;
        }
    }

    public static enum Type {
        RFU,
        READ_ONLY_STATUS,
        READ_WRITE_CONFIG,
        READ_WRITE,
        TYPE,
        READ_ONLY;

    }
}

