/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.interfaces;

import com.sic.module.nfc.tech.interfaces.IRegister;

public interface IGPIO
extends IRegister {
    public static final int LOGIC_LOW = 0;
    public static final int LOGIC_HIGH = 1;
    public static final byte PIN_7 = Pin.access$000(Pin.PIN_7);
    public static final byte PIN_6 = Pin.access$000(Pin.PIN_6);
    public static final byte PIN_5 = Pin.access$000(Pin.PIN_5);
    public static final byte PIN_4 = Pin.access$000(Pin.PIN_4);
    public static final byte PIN_3 = Pin.access$000(Pin.PIN_3);
    public static final byte PIN_2 = Pin.access$000(Pin.PIN_2);
    public static final byte PIN_1 = Pin.access$000(Pin.PIN_1);
    public static final byte PIN_0 = Pin.access$000(Pin.PIN_0);
    public static final byte ALL = -1;

    public static enum Pin {
        PIN_7(128),
        PIN_6(64),
        PIN_5(32),
        PIN_4(16),
        PIN_3(8),
        PIN_2(4),
        PIN_1(2),
        PIN_0(1);

        private final byte pin;

        private Pin(int pin) {
            this.pin = (byte)(pin & 0xFF);
        }

        public static byte parsePin(Pin ... pins) {
            byte sum = 0;
            for (Pin pin : pins) {
                sum = (byte)(sum | pin.get());
            }
            return sum;
        }

        public static byte parsePin(int ... pins) {
            byte sum = 0;
            for (int pin : pins) {
                sum = (byte)(sum | (int)Math.pow(2.0, pin) & 0xFF);
            }
            return sum;
        }

        public byte get() {
            return this.pin;
        }

        static /* synthetic */ byte access$000(Pin x0) {
            return x0.pin;
        }
    }
}

