/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s431x.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class UARTStatus
implements ILocalRegister {
    public static final byte ADDRESS = 0;
    public static final byte FACTORY_VALUE = 0;
    public static final String NAME = "UART Status";
    private static UARTStatus instance;

    public static ILocalRegister getInstance() {
        if (instance == null) {
            instance = new UARTStatus();
        }
        return instance;
    }

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_ONLY_STATUS;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_5: {
                return "CTS pin status indicator\nCTS become '1', when, external UART device is ready to receive data.\nIf CTS function is disable (by GPIO_Mode and GPIO_DIR), CTS = '1'.";
            }
            case BIT_4: {
                return "RTS pin status indicator\nRTS become '1', when UL FIFO is ready to receive data.\nIf RTS function is disable (by GPIO_Mode and GPIO_DIR), RTS is always '1'.";
            }
            case BIT_3: {
                return "Downlink FIFO Empty Indicator";
            }
            case BIT_2: {
                return "Downlink FIFO Overflow Indicator flag\n( Can be clear by command Clear_Flag)";
            }
            case BIT_1: {
                return "Uplink FIFO Empty Indicator";
            }
            case BIT_0: {
                return "Uplink FIFO Overflow Indicator flag\n( Can be clear by command Clear_Flag)";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 0;
    }

    public static class Params {
        public static final byte CTS = IRegister.Bit.parseBit(5);
        public static final byte RTS = IRegister.Bit.parseBit(4);
        public static final byte DL_FF_EMT = IRegister.Bit.parseBit(3);
        public static final byte DL_FF_OVF = IRegister.Bit.parseBit(2);
        public static final byte UL_FF_EMT = IRegister.Bit.parseBit(1);
        public static final byte UL_FF_OVF = IRegister.Bit.parseBit(0);
    }
}

