/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s431x.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class PowerStatus
implements ILocalRegister {
    public static final byte ADDRESS = 1;
    public static final byte FACTORY_VALUE = 0;
    public static final String NAME = "Power Status";
    private static PowerStatus instance;

    public static ILocalRegister getInstance() {
        if (instance == null) {
            instance = new PowerStatus();
        }
        return instance;
    }

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_ONLY_STATUS;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_4: {
                return "SCAP_RDY that equals to '1' means that voltage on pin SCAP is higher than 4.5V";
            }
            case BIT_3: {
                return "UART_RDY that equals to '1' means that on-chip oscillator is stable and ready to operate UART communication.";
            }
            case BIT_2: {
                return "XVDD_RDY that equals to '1' means that voltage on pin XVDD is higher than XVDD drop level.\nRegister LDO_D_LV defines threshold level for XVDD drop level.";
            }
            case BIT_1: {
                return "When PWR_RDY is set to '1', RF input power is higher than defined supplying level.\nPower supplying level can be set from register RFLM_LV.";
            }
            case BIT_0: {
                return "When LDO_ON is set to '1', on-chip LDO regulator is successfully turned on";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 1;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 0;
    }

    public static class Params {
        public static final byte SCAP_RDY = IRegister.Bit.parseBit(4);
        public static final byte UART_RDY = IRegister.Bit.parseBit(3);
        public static final byte XVDD_RDY = IRegister.Bit.parseBit(2);
        public static final byte RSPW_RDY = IRegister.Bit.parseBit(1);
        public static final byte LDO_ON = IRegister.Bit.parseBit(0);
    }
}

