/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class UARTFrame
implements ILocalRegister {
    public static final byte ADDRESS = 4;
    public static final byte FACTORY_VALUE = 8;
    public static final String NAME = "UART Frame";
    public static final byte STOP_1_BIT = IRegister.Bit.parseBit();
    public static final byte STOP_2_BIT = IRegister.Bit.parseBit(3);
    public static final byte PARITY_NONE = IRegister.Bit.parseBit();
    public static final byte PARITY_SPACE = IRegister.Bit.parseBit(2);
    public static final byte PARITY_MARK = IRegister.Bit.parseBit(2, 0);
    public static final byte PARITY_EVEN = IRegister.Bit.parseBit(2, 1);
    public static final byte PARITY_ODD = IRegister.Bit.parseBit(2, 1, 0);

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_3: {
                return "Stop_Len configures the stop bit of UART Byte\n\t0: 1 bit\n\t1: 2 bit";
            }
            case BIT_2: 
            case BIT_1: 
            case BIT_0: {
                return "Parity configures the Parity of UART Byte\n\t0XX: None\n\t100: '0' (Space)\n\t101: '1' (Space)\n\t110: Even\n\t111: Odd";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 4;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 8;
    }

    public static class Params {
        public static final byte STOP_LEN = IRegister.Bit.parseBit(3);
        public static final byte PARITY = IRegister.Bit.parseBit(2, 1, 0);
    }
}

