/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class TRxRUResponseTime
implements ILocalRegister {
    public static final byte ADDRESS = 3;
    public static final byte FACTORY_VALUE = 2;
    public static final String NAME = "TRxRU Response Time";
    public static final byte TIME_4096_MS = IRegister.Bit.parseBit(3, 2);
    public static final byte TIME_2048_MS = IRegister.Bit.parseBit(3, 1, 0);
    public static final byte TIME_1024_MS = IRegister.Bit.parseBit(3, 1);
    public static final byte TIME_512_MS = IRegister.Bit.parseBit(3, 0);
    public static final byte TIME_256_MS = IRegister.Bit.parseBit(3);
    public static final byte TIME_128_MS = IRegister.Bit.parseBit(2, 1, 0);
    public static final byte TIME_64_MS = IRegister.Bit.parseBit(2, 1);
    public static final byte TIME_32_MS = IRegister.Bit.parseBit(2, 0);
    public static final byte TIME_16_MS = IRegister.Bit.parseBit(2);
    public static final byte TIME_8_MS = IRegister.Bit.parseBit(1, 0);
    public static final byte TIME_4_MS = IRegister.Bit.parseBit(1);
    public static final byte TIME_2_MS = IRegister.Bit.parseBit(0);
    public static final byte TIME_1_MS = IRegister.Bit.parseBit();

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_3: 
            case BIT_2: 
            case BIT_1: 
            case BIT_0: {
                return "TRxRU_Time defines the response timeout for Transceive command\nTransceive Response Time = ( 2^TRxRU_Time ) x ( 1 ms ). \nMaximum value of TRxRU_Time is 12. Hence, Maximum response time is 4 s.";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 3;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 2;
    }

    public static class Params {
        public static final byte TRXRU_TIME = IRegister.Bit.parseBit(3, 2, 1, 0);
    }
}

