/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class PeripheralAdjustment
implements ILocalRegister {
    public static final byte ADDRESS = 14;
    public static final byte FACTORY_VALUE = 1;
    public static final String NAME = "Peripheral Adjustment";
    public static final byte LDO_D_LV_2_4 = IRegister.Bit.parseBit();
    public static final byte LDO_D_LV_2_7 = IRegister.Bit.parseBit(2);
    public static final byte RFLM_LV_5_2 = IRegister.Bit.parseBit();
    public static final byte RFLM_LV_6_5 = IRegister.Bit.parseBit(1);
    public static final byte RESP_FLAG_1_BIT = IRegister.Bit.parseBit();
    public static final byte RESP_FLAG_2_BIT = IRegister.Bit.parseBit(0);

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_2: {
                return "Define threshold voltage drop level at pin XVDD that set XVDD_RDY flag.\n\t0: 2.4 volt\n\t1: 2.7 volt";
            }
            case BIT_1: {
                return "Define RF limiter level to limit charging voltage on pin SCAP and pin HV\n\t0: 5.2 volt (maximum of SCAP voltage = 4.8 volt)\n\t1: 6.5 volt (maximum of SCAP voltage = 6.0 volt)";
            }
            case BIT_0: {
                return "Define the number of response flag in RF response packet to make the response compatible with some NFC chips/phone in market to guarantee minimum two byte in response frame.\n\t0: Response Flag in response package is set to one byte.\n\t1: Response Flag in response package is set to two bytes for some downlink commands to guarantee that uplink response frame contains at least 2 bytes to make operation compatible with some NFC phones in market that don't accept one bytes response.";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 14;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 1;
    }

    public static class Params {
        public static final byte LDO_D_LV = IRegister.Bit.parseBit(2);
        public static final byte RFLM_LV = IRegister.Bit.parseBit(1);
        public static final byte RESP_FLAG_N_BIT = IRegister.Bit.parseBit(0);
    }
}

