/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class OSCTuning
implements ILocalRegister {
    public static final byte ADDRESS = 7;
    public static final byte FACTORY_VALUE = 8;
    public static final String NAME = "OSC Tuning";
    public static final byte OSC_TUNING_HIGHEST = IRegister.Bit.parseBit();
    public static final byte OSC_TUNING_LOWEST = IRegister.Bit.parseBit(3, 2, 1, 0);

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_WRITE;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_3: 
            case BIT_2: 
            case BIT_1: 
            case BIT_0: {
                return "OSC_Tuning use to fine tune frequency of on-chip oscillator.\n\t0000: frequency is set to the highest adjustable value.\n\t1111: frequency is set to the lowest adjustable value.\nNote that on-chip frequency is tuned to 1.8432MHz during\nmanufacturing. Generally, user don't need to tune the frequency.\nOSC_Tuning optionally provides a way to tune the frequency.";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 7;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 8;
    }

    public static class Params {
        public static final byte OSC_TUNING = IRegister.Bit.parseBit(3, 2, 1, 0);
    }
}

