/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310;

import android.content.Context;
import com.sic.module.nfc.tech.chips.s4310.GPIO;
import com.sic.module.nfc.tech.chips.s4310.Register;
import com.sic.module.nfc.tech.chips.s4310.UART;
import com.sic.module.nfc.tech.chips.s431x.SIC431x;
import com.sic.module.nfc.tech.chips.s431x.registers.PowerStatus;
import com.sic.module.utils.AppContext;

public class SIC4310
extends SIC431x {
    private static final String TAG = SIC4310.class.getName();
    private static SIC4310 instance;

    protected SIC4310(Context context) {
        super(context);
    }

    public static SIC4310 getInstance() {
        return SIC4310.getInstance(AppContext.getInstance().getContext());
    }

    public static SIC4310 getInstance(Context context) {
        if (instance == null) {
            instance = new SIC4310(context);
        }
        return instance;
    }

    public Register getRegister() {
        return Register.getInstance();
    }

    public GPIO getGPIO() {
        return GPIO.getInstance();
    }

    public UART getUART() {
        return UART.getInstance();
    }

    public boolean isPowerSuperCapReady() {
        byte flag = this.getPowerMeasurementStatus();
        return (flag & PowerStatus.Params.SCAP_RDY) == PowerStatus.Params.SCAP_RDY;
    }

    public boolean isPowerUARTReady() {
        byte flag = this.getPowerMeasurementStatus();
        return (flag & PowerStatus.Params.UART_RDY) == PowerStatus.Params.UART_RDY;
    }

    public boolean isPowerXVDDReady() {
        byte flag = this.getPowerMeasurementStatus();
        return (flag & PowerStatus.Params.XVDD_RDY) == PowerStatus.Params.XVDD_RDY;
    }

    public boolean isPowerReady() {
        byte flag = this.getPowerMeasurementStatus();
        return (flag & PowerStatus.Params.RSPW_RDY) == PowerStatus.Params.RSPW_RDY;
    }

    public boolean isPowerLDOOn() {
        byte flag = this.getPowerMeasurementStatus();
        return (flag & PowerStatus.Params.LDO_ON) == PowerStatus.Params.LDO_ON;
    }

    public boolean sync() {
        this.clearFlagsRegister();
        this.getRegister().sync();
        this.getGPIO().sync();
        return this.getRegister().isSync();
    }
}

