/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310;

import com.sic.module.nfc.tech.chips.s431x.xRegister;

public class Register
extends xRegister {
    public static final byte UART_STATUS = 0;
    public static final byte POWER_STATUS = 1;
    public static final byte TRXRU_RESPONSE_TIME = 3;
    public static final byte UART_FRAME = 4;
    public static final byte UART_DIVIDER_M = 5;
    public static final byte UART_DIVIDER_N = 6;
    public static final byte OSC_TUNING = 7;
    public static final byte GPIO_DIRECTION = 8;
    public static final byte GPIO_MODE = 9;
    public static final byte GPIO_OUT = 10;
    public static final byte GPIO_IN = 11;
    public static final byte GPIO_PULLUP = 12;
    public static final byte PERIPHERAL_CONFIG = 13;
    public static final byte PERIPHERAL_ADJUSTMENT = 14;
    private static final String TAG = Register.class.getSimpleName();
    private static final int REGISTER_PAGE = 16;
    private static Register instance;

    public static Register getInstance() {
        if (instance == null) {
            instance = new Register();
        }
        return instance;
    }

    public static String getRegisterName(byte addr) {
        String header;
        switch (addr) {
            case 0: {
                header = "UART Status";
                break;
            }
            case 1: {
                header = "Power Status";
                break;
            }
            case 3: {
                header = "TRxRU Response time";
                break;
            }
            case 4: {
                header = "Byte Configuration";
                break;
            }
            case 5: {
                header = "UART Clock Divider 1";
                break;
            }
            case 6: {
                header = "UART Clock Divider 2";
                break;
            }
            case 7: {
                header = "OSC Tuning";
                break;
            }
            case 8: {
                header = "GPIO Direction";
                break;
            }
            case 9: {
                header = "GPIO Mode";
                break;
            }
            case 10: {
                header = "GPIO Out";
                break;
            }
            case 11: {
                header = "GPIO In";
                break;
            }
            case 12: {
                header = "GPIO Pull-up";
                break;
            }
            case 13: {
                header = "Peripheral Config";
                break;
            }
            case 14: {
                header = "Peripheral Adjustment";
                break;
            }
            default: {
                header = "Unknown Register";
            }
        }
        return header;
    }

    public static String getRegisterDescription(byte bCode) {
        switch (bCode) {
            case 0: {
                return "Bit 7 - 6 : RFU \n\nBit 5 : CTS - R/O - Status.\n\t\t0 : CTS function is disable or not ready.\n\t\t1 : External UART device is ready to receive data.\n\nBit 4 : RTS - R/O - Status.\n\t\t0 : RTS function is disable or not ready.\n\t\t1 : UL FIFO is ready to receive data.\n\nBit 3 : DL_FF_EMT - R/O - Status.\n\t\t0 : - \n\t\t1 : Downlink FIFO Empty Indicator flag. \n\nBit 2 : DL_FF_OVF - R/O - Status.\n\t\t0 : - \n\t\t1 : Downlink FIFO Overflow Indicator flag. (Can be clear by command Clear_Flag)\n\nBit 1 : UL_FF_EMT - R/O - Status.\n\t\t0 : - \n\t\t1 : Uplink FIFO Empty Indicator flag. \n\nBit 0 : UL_FF_OVF - R/O - Status.\n\t\t0 : - \n\t\t1 : Uplink FIFO Overflow Indicator flag. (Can be clear by command Clear_Flag)\n\n";
            }
            case 1: {
                return "Bit 7 - 5 : RFU \n\nBit 4 : SCAP_RDY - R/O - Status.\n\t\t0 : - \n\t\t1 : Voltage on pin SCAP is higher than 4.5V.\n\nBit 3 : UART_RDY - R/O - Status.\n\t\t0 : - \n\t\t1 : On-chip oscillator is stable and ready to operate UART communication.\n\nBit 2 : XVDD_RDY - R/O - Status.\n\t\t0 : - \n\t\t1 : Voltage on pin XVDD is higher than XVDD drop level (set from LDO_D_LV).\n\nBit 1 : RSPW_RDY - R/O - Status.\n\t\t0 : - \n\t\t1 :\tReserve power from RF is higher than defined supplying level. (set from RFLM_LV).\n\nBit 0 : LDO_ON - R/O - Status.\n\t\t0 : - \n\t\t1 :\tOn-chip LDO regulator is successfully turned on.\n\n";
            }
            case 2: {
                return "Bit 7 - 0 : RFU \n\n";
            }
            case 3: {
                return "Bit 7 - 4 : RFU \n\nBit 3 - 0 : TRxRU_Time - R/W - Config\n\t\tTransceive Response Time = ( 2^TRxRU_Time ) x ( 1 ms ). \n\t\tMaximum value of TRxRU_Time is 12. Hence, Maximum response time is 4 s.\n\nFactory Preprogram Register Value\n\t\t0x04 \n\n";
            }
            case 4: {
                return "Bit 7 - 5 : RFU \n\nBit 4 : Stop_Len - R/W - Config\n\t\t0 : 1 stop bit of UART.\n\t\t1 : 2 stop bits of UART.\n\nBit 3 - 0 : Parity - R/W - Config\n\t\t0XX : None parity of UART.\n\t\t100 : Space (0) parity of UART.\n\t\t101 : Mark (1) parity of UART.\n\t\t110 : Even parity of UART.\n\t\t111 : Odd parity of UART.\n\nFactory Preprogram Register Value\n\t\t0x08 \n\n";
            }
            case 5: {
                return "Bit 7 - 6 : RFU \n\nBit 5 - 0 : UART_DIV_m - R/W - Config\n\t\tUART clock to set speed of UART communication. It must be used together with UART_Divisor_n (Reg 0x06).\n\t\t0 : the divisor is 64.\n\nFactory Preprogram Register Value\n\t\t0x01 \n\n";
            }
            case 6: {
                return "Bit 7 - 6 : RFU \n\nBit 5 - 0 : UART_DIV_n - R/W - Config\n\t\tUART clock to set speed of UART communication. It must be used together with UART_Divisor_m (Reg 0x05).\n\t\tIf value is less than 2 : SIC4310 can not perform communication.\n\nFactory Preprogram Register Value\n\t\t0x10 \n\n";
            }
            case 7: {
                return "Bit 7 - 4 : RFU \n\nBit 5 - 0 : OSC_Tuning - R/W\n\t\t0000 : frequency is set to the highest adjustable value.\n\t\t1111 : frequency is set to the lowest adjustable value.\n\nFactory Preprogram Register Value\n\t\t0x08 \n\n";
            }
            case 8: {
                return "Bit 7 - 0 : DIR [7:0] - R/W - Config\n\t\t0 : GPIO input direction.\n\t\t1 : GPIO output direction.\n\nFactory Preprogram Register Value\n\t\t0x03 \n\n";
            }
            case 9: {
                return "Bit 7 - 0 : Mode [7:0] - R/W - Config\n\t\t0 : General Purpose I/O.\n\t\t1 : Special Function.\n\nFactory Preprogram Register Value\n\t\t0x07 \n\n";
            }
            case 10: {
                return "Bit 7 - 0 : Out [7:0] - R/W - Config\n\t\t0 : GPIO output is logic low.\n\t\t1 : GPIO output is logic high.\n\n\nFactory Preprogram Register Value\n\t\t0x00 \n\n";
            }
            case 11: {
                return "Bit 7 - 0 : IN [7:0] - R/O - Status\n\t\t0 : GPIO input is logic low.\n\t\t1 : GPIO input is logic high.\n\n";
            }
            case 12: {
                return "Bit 7 - 0 : PU [7:0] - R/W - Config\n\t\t0 : Disable Pull Up resistor.\n\t\t1 : Enable Pull Up resistor when set to Input.\n\nFactory Preprogram Register Value\n\t\t0x00 \n\n";
            }
            case 13: {
                return "Bit 7 - 4 : RFU \n\nBit 5 - 4 : PW_LV[1:0] - R/W \u2013 Config\n\t\t00 : Threshold of power: 500 \u00b5A\n\t\t01 : Threshold of power: 1.25 mA\n\t\t10 : Threshold of power: 2.50 mA\n\t\t11 : Threshold of power: 5.00 mA\nBit 3 : RFU \n\nBit 2 : PWCHK_EN - R/W \u2013 Config\n\t\t0 : Disable (on-chip LDO is on immediately without qualifying process).\n\t\t1 : Enable qualifying process.\n\nBit 1 : LDO_EN - R/W \u2013 Config\n\t\t0 : Disable LDO Regulator.\n\t\t1 : Enable LDO Regulator.\n\nBit 0 : OSC_EN - R/W \u2013 Config\n\t\t0 : Disable on-chip oscillator.\n\t\t1 : Enable on-chip oscillator.\n\nFactory Preprogram Register Value\n\t\t0x11 \n\n";
            }
            case 14: {
                return "Bit 7 - 3 : RFU \n\nBit 2 : LDO_D_LV - R/W - Config\n\t\t0 : Threshold voltage drop level 2.4 volt.\n\t\t1 : Threshold voltage drop level 2.7 volt.\nBit 1 : RFLM_LV - R/W - Config\n\t\t0 : RF limiter level 5.2 volt (maximum of SCAP voltage = 4.8 volt).\n\t\t1 : RF limiter level 6.5 volt (maximum of SCAP voltage = 6.0 volt).\nBit 0 : 2B_FLAG - R/W - Config\n\t\t0 : All response package is set to 1 byte.\n\t\t1 : Some response package is set to 2 bytes.\n\nFactory Preprogram Register Value\n\t\t0x00 \n\n";
            }
        }
        return "Address Incorrect.\n";
    }

    @Override
    protected int getRegisterPage() {
        return 16;
    }

    public Byte getResponseTime() {
        return this.read((byte)3);
    }

    public void setResponseTime(int time) {
        this.write((byte)3, (byte)time);
    }
}

