/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310;

import com.sic.module.nfc.tech.chips.s4310.Register;
import com.sic.module.nfc.tech.chips.s431x.xGPIO;
import com.sic.module.nfc.tech.interfaces.IGPIO;
import com.sic.module.utils.SICLog;

public class GPIO
extends xGPIO {
    public static final byte PIN_UART_RX = IGPIO.Pin.parsePin(2);
    public static final byte PIN_UART_CTS = IGPIO.Pin.parsePin(0);
    public static final byte PIN_PWR_RDY = IGPIO.Pin.parsePin(5);
    public static final byte PIN_RF_BUSY = IGPIO.Pin.parsePin(4);
    public static final byte PIN_UART_RTS = IGPIO.Pin.parsePin(3);
    public static final byte PIN_UART_TX = IGPIO.Pin.parsePin(1);
    public static final byte PIN_RF_DETECT = IGPIO.Pin.parsePin(0);
    public static final byte DIRECTION_INPUT = 0;
    public static final byte DIRECTION_OUTPUT = 1;
    public static final byte GPIO_MODE = 0;
    public static final byte FUNCTION_MODE = 1;
    private static final String TAG = GPIO.class.getName();
    private static GPIO instance;
    private final Register mRegister = Register.getInstance();
    private byte direction;
    private byte mode;
    private byte output;
    private byte pullup;

    private GPIO() {
    }

    public static GPIO getInstance() {
        if (instance == null) {
            instance = new GPIO();
        }
        return instance;
    }

    @Override
    public void sync() {
        if (!this.mRegister.isSync()) {
            this.mRegister.sync();
        }
        Byte direction = this.mRegister.readBuffer((byte)8);
        Byte mode = this.mRegister.readBuffer((byte)9);
        Byte output = this.mRegister.readBuffer((byte)10);
        Byte pullup = this.mRegister.readBuffer((byte)12);
        if (direction != null && mode != null && output != null && pullup != null) {
            this.direction = direction;
            this.mode = mode;
            this.output = output;
            this.pullup = pullup;
        }
    }

    private void config(int addr, byte bit, int val) {
        switch (addr) {
            case 8: {
                this.setBitDirection(bit, val);
                break;
            }
            case 9: {
                this.setBitMode(bit, val);
                break;
            }
            case 10: {
                this.setBitOutput(bit, val);
                break;
            }
            default: {
                SICLog.i(TAG, "the address is incorrectly.");
            }
        }
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setDirection(byte GPIO_Dir) {
        this.direction = GPIO_Dir;
        this.mRegister.write((byte)8, this.direction);
    }

    public void setBitDirection(byte pin, int value) {
        this.direction = value == 0 ? (byte)(this.direction & ~pin) : (byte)(this.direction | pin);
        this.mRegister.write((byte)8, this.direction);
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte GPIO_Mode) {
        this.mode = GPIO_Mode;
        this.mRegister.write((byte)9, this.mode);
    }

    public void setBitMode(byte pin, int value) {
        this.mode = value == 0 ? (byte)(this.mode & ~pin) : (byte)(this.mode | pin);
        this.mRegister.write((byte)9, this.mode);
    }

    @Override
    public byte getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(byte GPIO_Out) {
        this.output = GPIO_Out;
        this.mRegister.write((byte)10, this.output);
    }

    @Override
    public void setBitOutput(byte pin, int value) {
        this.output = value == 0 ? (byte)(this.output & ~pin) : (byte)(this.output | pin);
        this.mRegister.write((byte)10, this.output);
    }

    @Override
    public Byte getInput() {
        Byte recv = this.mRegister.read((byte)11);
        if (recv == null) {
            SICLog.e(TAG, "Can not get GPIO input.");
            return null;
        }
        return recv;
    }

    @Override
    public Byte getBitInput(byte pin) {
        Byte recv = this.getInput();
        if (recv == null) {
            return null;
        }
        if ((recv & pin) == pin) {
            return (byte)1;
        }
        return (byte)0;
    }

    public void setGPIOModeInputDirection(byte pin) {
        this.config(8, pin, 0);
        this.config(9, pin, 0);
    }

    public void setGPIOModeOutputDirection(byte pin) {
        this.config(8, pin, 1);
        this.config(9, pin, 0);
    }

    public void setFunctionModeInputDirection(byte pin) {
        this.config(8, pin, 0);
        this.config(9, pin, 1);
    }

    public void setFunctionModeOutputDirection(byte pin) {
        this.config(8, pin, 1);
        this.config(9, pin, 1);
    }

    public void setPullup(byte GPIO_Pullup) {
        this.pullup = GPIO_Pullup;
        this.mRegister.write((byte)12, GPIO_Pullup);
    }

    public void setBitPullup(int pos, int val) {
        byte bit = (byte)pos;
        this.pullup = val == 0 ? (byte)(this.pullup & ~bit) : (byte)(this.pullup | bit);
        this.mRegister.write((byte)12, this.pullup);
    }
}

