/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.os.Build;
import com.sic.module.nfc.NfcWrapper;
import com.sic.module.utils.Boast;
import com.sic.module.utils.SICLog;

public abstract class Nfc {
    private static final String TAG = Nfc.class.getName();
    private final IntentFilter[] mIntentFilters;
    private final String[][] mTechLists;
    private final Context mContext;
    private final NfcAdapter mNfcAdapter;
    private Tag tag;
    private volatile NFC_STATE mState = NFC_STATE.PAUSED;
    private volatile NFC_MODE mInterfaceMode = NFC_MODE.PASSTHROUGH;

    protected Nfc(Context context, IntentFilter[] intentFilters, String[][] techLists) {
        this.mContext = context;
        this.mNfcAdapter = NfcWrapper.getInstance().getAdapter(this.mContext);
        this.mIntentFilters = intentFilters;
        this.mTechLists = techLists;
        this.checkNfcAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Activity activity) {
        this.mState = NFC_STATE.RESUMING;
        if (this.mNfcAdapter != null) {
            Nfc nfc = this;
            synchronized (nfc) {
                this.installNfcHandler(activity);
            }
        }
        this.mState = NFC_STATE.RESUMED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Activity activity) {
        this.mState = NFC_STATE.PAUSING;
        if (this.mNfcAdapter != null) {
            Nfc nfc = this;
            synchronized (nfc) {
                this.mNfcAdapter.disableForegroundDispatch(activity);
            }
        }
        this.mState = NFC_STATE.PAUSED;
    }

    public boolean onTagFinding(Intent intent) {
        this.mInterfaceMode = NFC_MODE.TAG_FINDING;
        new TagHandlerThread(intent).start();
        try {
            while (this.mInterfaceMode == NFC_MODE.TAG_FINDING) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.mInterfaceMode == NFC_MODE.EXCHANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        this.mInterfaceMode = NFC_MODE.PASSTHROUGH;
        Nfc nfc = this;
        synchronized (nfc) {
            try {
                if (this.mState == NFC_STATE.PAUSING || this.mState == NFC_STATE.PAUSED) {
                    return;
                }
                this.mNfcAdapter.disableForegroundDispatch((Activity)this.mContext);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (NullPointerException ignored) {
                Boast.showToast((Activity)this.mContext, "Your phone is not support a NFC Technology.");
            }
        }
    }

    public boolean isNfcTag() {
        try {
            while (this.mInterfaceMode == NFC_MODE.TAG_FINDING) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.tag != null;
    }

    private void checkNfcAdapter() {
        if (this.mNfcAdapter == null) {
            SICLog.i(TAG, "Nfc implementation not available.");
        } else if (!this.mNfcAdapter.isEnabled()) {
            Boast.showToast((Activity)this.mContext, "Please activate NFC and press Back to return to the application!");
            if (Build.VERSION.SDK_INT >= 16) {
                Intent intent = new Intent("android.settings.NFC_SETTINGS");
                intent.addFlags(0x10000000);
                this.mContext.startActivity(intent);
            } else {
                Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
                intent.addFlags(0x10000000);
                this.mContext.startActivity(intent);
            }
        }
    }

    private void installNfcHandler(Activity activity) {
        Intent activityIntent = new Intent(this.mContext, activity.getClass());
        activityIntent.addFlags(0x20000000);
        PendingIntent intent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)activityIntent, (int)0x10000000);
        this.mNfcAdapter.enableForegroundDispatch(activity, intent, this.mIntentFilters, this.mTechLists);
    }

    public Tag getTag() {
        return this.tag;
    }

    public byte[] getUID() {
        return this.tag.getId();
    }

    private class TagHandlerThread
    extends Thread {
        final Intent mIntent;

        TagHandlerThread(Intent intent) {
            this.mIntent = intent;
        }

        @Override
        public void run() {
            Nfc.this.tag = (Tag)this.mIntent.getParcelableExtra("android.nfc.extra.TAG");
            if (Nfc.this.tag != null) {
                Nfc.this.mInterfaceMode = NFC_MODE.EXCHANGE;
            } else {
                Nfc.this.disable();
            }
        }
    }

    private static enum NFC_MODE {
        PASSTHROUGH,
        TAG_FINDING,
        EXCHANGE;

    }

    private static enum NFC_STATE {
        PAUSED,
        PAUSING,
        RESUMING,
        RESUMED;

    }
}

