/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.interfaces;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/15/2015
 */
public interface IGPIO extends IRegister {

    int LOGIC_LOW = 0;
    int LOGIC_HIGH = 1;

    byte PIN_7 = Pin.PIN_7.pin;
    byte PIN_6 = Pin.PIN_6.pin;
    byte PIN_5 = Pin.PIN_5.pin;
    byte PIN_4 = Pin.PIN_4.pin;
    byte PIN_3 = Pin.PIN_3.pin;
    byte PIN_2 = Pin.PIN_2.pin;
    byte PIN_1 = Pin.PIN_1.pin;
    byte PIN_0 = Pin.PIN_0.pin;
    byte ALL = (byte) 0xFF;

    enum Pin {
        PIN_7(0x80),
        PIN_6(0x40),
        PIN_5(0x20),
        PIN_4(0x10),
        PIN_3(0x08),
        PIN_2(0x04),
        PIN_1(0x02),
        PIN_0(0x01);

        private final byte pin;

        Pin(int pin) {
            this.pin = (byte) (pin & 0xFF);
        }

        public static byte parsePin(Pin... pins) {
            byte sum = 0x00;
            for (Pin pin : pins) {
                sum |= pin.get();
            }
            return sum;

        }

        public static byte parsePin(int... pins) {
            byte sum = 0x00;
            for (int pin : pins) {
                sum |= (int) Math.pow(2, pin) & 0xff;
            }
            return sum;
        }

        public byte get() {
            return pin;
        }


    }
}
