/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s431x;

import com.sic.module.nfc.tech.interfaces.IGPIO;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.1
 * @since 7/14/2015
 */
public abstract class xGPIO implements IGPIO {

    private static final String TAG = xGPIO.class.getName();

    public abstract void sync();

    /**
     * Get GPIO Output register
     *
     * @return GPIO Output register
     */
    public abstract byte getOutput();

    /**
     * Set GPIO output register
     *
     * @param GPIO_Out GPIO output
     */
    public abstract void setOutput(byte GPIO_Out);

    /**
     * Set bit of GPIO output register
     *
     * @param pin   GPIO
     * @param value output
     */
    public abstract void setBitOutput(byte pin, int value);

    /**
     * Get current GPIO input port of GPIO variable. 0 is input and 1 is output.
     * if transceiver failed then return null
     *
     * @return GPIO_Input
     */
    public abstract Byte getInput();

    /**
     * Get a selected GPIO input port of GPIO variable. 0 is input and 1 is
     * output. if transceiver failed then return null
     *
     * @param pin GPIO pin.
     * @return pin selected GPIO pin
     */
    public abstract Byte getBitInput(byte pin);

    /**
     * Set a selected pin to logic high.
     *
     * @param pin selected GPIO pin.
     */
    public void setHighOutput(byte pin) {
        setBitOutput(pin, LOGIC_HIGH);
    }

    /**
     * Set a selected pin to logic low.
     *
     * @param pin selected GPIO pin
     */
    public void setLowOutput(byte pin) {
        setBitOutput(pin, LOGIC_LOW);
    }

    /**
     * Toggle logic of a selected GPIO pin.
     *
     * @param pin selected GPIO pin
     */
    public void setToggleOutput(byte pin) {
        byte output = getOutput();
        byte sel = (byte) (pin & ~output);
        byte uns = (byte) (~pin & output);
        setOutput((byte) (sel | uns));
    }
}
