/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s431x.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class UARTStatus implements ILocalRegister {

    public static final byte ADDRESS = 0x00;
    public static final byte FACTORY_VALUE = 0x00;
    public static final String NAME = "UART Status";
    private static UARTStatus instance;

    public static ILocalRegister getInstance() {
        if (instance == null) {
            instance = new UARTStatus();
        }
        return instance;
    }

    @Override
    public Type getType() {
        return Type.READ_ONLY_STATUS;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_5:
                return "CTS pin status indicator\n" +
                        "CTS become '1', when, external UART device is ready to receive data.\n" +
                        "If CTS function is disable (by GPIO_Mode and GPIO_DIR), CTS = '1'.";
            case BIT_4:
                return "RTS pin status indicator\n" +
                        "RTS become '1', when UL FIFO is ready to receive data.\n" +
                        "If RTS function is disable (by GPIO_Mode and GPIO_DIR), RTS is always '1'.";
            case BIT_3:
                return "Downlink FIFO Empty Indicator";
            case BIT_2:
                return "Downlink FIFO Overflow Indicator flag\n" +
                        "( Can be clear by command Clear_Flag)";
            case BIT_1:
                return "Uplink FIFO Empty Indicator";
            case BIT_0:
                return "Uplink FIFO Overflow Indicator flag\n" +
                        "( Can be clear by command Clear_Flag)";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte CTS = Bit.parseBit(5);
        public static final byte RTS = Bit.parseBit(4);
        public static final byte DL_FF_EMT = Bit.parseBit(3);
        public static final byte DL_FF_OVF = Bit.parseBit(2);
        public static final byte UL_FF_EMT = Bit.parseBit(1);
        public static final byte UL_FF_OVF = Bit.parseBit(0);
    }


}
