/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s431x.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class RFU implements ILocalRegister {

    public static final byte FACTORY_VALUE = 0x00;
    public static final String NAME = "RFU";
    public static byte ADDRESS = (byte) 0xFF;
    private static RFU instance;

    public static RFU getInstance(byte addr) {
        if (instance == null) {
            instance = new RFU();
        }
        ADDRESS = addr;
        return instance;
    }

    public static ILocalRegister getInstance() {
        return null;
    }

    @Override
    public Type getType() {
        return Type.RFU;
    }

    @Override
    public String getDescription(Bit bit) {
        return "Unknown Register";
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }
}
