/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s431x.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class PowerStatus implements ILocalRegister {

    public static final byte ADDRESS = 0x01;
    public static final byte FACTORY_VALUE = 0x00;
    public static final String NAME = "Power Status";
    private static PowerStatus instance;

    public static ILocalRegister getInstance() {
        if (instance == null) {
            instance = new PowerStatus();
        }
        return instance;
    }

    @Override
    public Type getType() {
        return Type.READ_ONLY_STATUS;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_4:
                return "SCAP_RDY that equals to '1' means that voltage on pin SCAP is higher than 4.5V";
            case BIT_3:
                return "UART_RDY that equals to '1' means that on-chip oscillator is stable and ready to operate UART communication.";
            case BIT_2:
                return "XVDD_RDY that equals to '1' means that voltage on pin XVDD is higher than XVDD drop level.\n" +
                        "Register LDO_D_LV defines threshold level for XVDD drop level.";
            case BIT_1:
                return "When PWR_RDY is set to '1', RF input power is higher than defined supplying level.\n" +
                        "Power supplying level can be set from register RFLM_LV.";
            case BIT_0:
                return "When LDO_ON is set to '1', on-chip LDO regulator is successfully turned on";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte SCAP_RDY = Bit.parseBit(4);
        public static final byte UART_RDY = Bit.parseBit(3);
        public static final byte XVDD_RDY = Bit.parseBit(2);
        public static final byte RSPW_RDY = Bit.parseBit(1);
        public static final byte LDO_ON = Bit.parseBit(0);
    }
}
