/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class UARTFrame implements ILocalRegister {

    public static final byte ADDRESS = 0x04;
    public static final byte FACTORY_VALUE = 0x08;
    public static final String NAME = "UART Frame";
    public static final byte STOP_1_BIT = Bit.parseBit();
    public static final byte STOP_2_BIT = Bit.parseBit(3);
    public static final byte PARITY_NONE = Bit.parseBit();
    public static final byte PARITY_SPACE = Bit.parseBit(2);
    public static final byte PARITY_MARK = Bit.parseBit(2, 0);
    public static final byte PARITY_EVEN = Bit.parseBit(2, 1);
    public static final byte PARITY_ODD = Bit.parseBit(2, 1, 0);

    @Override
    public Type getType() {
        return Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_3:
                return "Stop_Len configures the stop bit of UART Byte\n" +
                        "\t0: 1 bit\n" +
                        "\t1: 2 bit";
            case BIT_2:
            case BIT_1:
            case BIT_0:
                return "Parity configures the Parity of UART Byte\n" +
                        "\t0XX: None\n" +
                        "\t100: '0' (Space)\n" +
                        "\t101: '1' (Space)\n" +
                        "\t110: Even\n" +
                        "\t111: Odd";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte STOP_LEN = Bit.parseBit(3);
        public static final byte PARITY = Bit.parseBit(2, 1, 0);
    }
}
