/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class UARTDivisor_M implements ILocalRegister {

    public static final byte ADDRESS = 0x05;
    public static final byte FACTORY_VALUE = 0x01;
    public static final String NAME = "UART Divisor M";

    @Override
    public Type getType() {
        return Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(Bit bit) {

        switch (bit) {
            case BIT_5:
            case BIT_4:
            case BIT_3:
            case BIT_2:
            case BIT_1:
            case BIT_0:
                return "UART_Divisor_m defines divisor m for UART clock to set speed of UART communication.\n" +
                        "UART_Divisor_m must be used together with UART_Divisor_n (Reg0x06).\n" +
                        "When m is set to 0, the divisor is 64.";
        }

        return "RFU";
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte UART_DIV_M = Bit.parseBit(5, 4, 3, 2, 1, 0);
    }
}
