/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class TRxRUResponseTime implements ILocalRegister {

    public static final byte ADDRESS = 0x03;
    public static final byte FACTORY_VALUE = 0x02;
    public static final String NAME = "TRxRU Response Time";
    public static final byte TIME_4096_MS = Bit.parseBit(3, 2);
    public static final byte TIME_2048_MS = Bit.parseBit(3, 1, 0);
    public static final byte TIME_1024_MS = Bit.parseBit(3, 1);
    public static final byte TIME_512_MS = Bit.parseBit(3, 0);
    public static final byte TIME_256_MS = Bit.parseBit(3);
    public static final byte TIME_128_MS = Bit.parseBit(2, 1, 0);
    public static final byte TIME_64_MS = Bit.parseBit(2, 1);
    public static final byte TIME_32_MS = Bit.parseBit(2, 0);
    public static final byte TIME_16_MS = Bit.parseBit(2);
    public static final byte TIME_8_MS = Bit.parseBit(1, 0);
    public static final byte TIME_4_MS = Bit.parseBit(1);
    public static final byte TIME_2_MS = Bit.parseBit(0);
    public static final byte TIME_1_MS = Bit.parseBit();

    @Override
    public Type getType() {
        return Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_3:
            case BIT_2:
            case BIT_1:
            case BIT_0:
                return "TRxRU_Time defines the response timeout for Transceive command\n" +
                        "Transceive Response Time = ( 2^TRxRU_Time ) x ( 1 ms ). \n" +
                        "Maximum value of TRxRU_Time is 12. Hence, Maximum response time is 4 s.";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte TRXRU_TIME = Bit.parseBit(3, 2, 1, 0);
    }
}
