/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class PeripheralConfig implements ILocalRegister {

    public static final byte ADDRESS = 0x0D;
    public static final byte FACTORY_VALUE = 0x07;
    public static final String NAME = "Peripheral Config";
    public static final byte PW_LV_500_UA = Bit.parseBit();
    public static final byte PW_LV_1250_UA = Bit.parseBit(4);
    public static final byte PW_LV_2500_UA = Bit.parseBit(5);
    public static final byte PW_LV_5000_UA = Bit.parseBit(5, 4);
    public static final byte PWCHK_DISABLE = Bit.parseBit();
    public static final byte PWCHK_ENABLE = Bit.parseBit(2);
    public static final byte LDO_DISABLE = Bit.parseBit();
    public static final byte LDO_ENABLE = Bit.parseBit(1);
    public static final byte OSC_DISABLE = Bit.parseBit();
    public static final byte OSC_ENABLE = Bit.parseBit(0);

    @Override
    public Type getType() {
        return Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_5:
            case BIT_4:
                return "PW_LV defines threshold power level received from coil to turn on LDO for driving external load on XVDD.\n" +
                        "\t00: 500 uA\n" +
                        "\t01: 1.25 mA\n" +
                        "\t10: 2.50 mA\n" +
                        "\t11: 5.00 mA";
            case BIT_2:
                return "PWCHK_EN enable qualifying process before turning on the on-chip LDO.\n" +
                        "\t0: Disable ( on-chip LDO is turned on immediately when LDO_EN is set to '1' without qualifying process and RSPW_RDY is always be '1')\n" +
                        "\t1: Enable";
            case BIT_1:
                return "LDO_EN enable the on-chip LDO Regulator\n" +
                        "\t0: Disable LDO\n" +
                        "\t1: Enable LDO";
            case BIT_0:
                return "OSC_EN enable on-chip oscillator for UART communication.\n" +
                        "\t0: Disable on-chip oscillator\n" +
                        "\t1: Enable on-chip oscillator";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte PW_LV = Bit.parseBit(5, 4);
        public static final byte PWCHK_EN = Bit.parseBit(2);
        public static final byte LDO_EN = Bit.parseBit(1);
        public static final byte OSC_EN = Bit.parseBit(0);
    }
}
