/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class PeripheralAdjustment implements ILocalRegister {

    public static final byte ADDRESS = 0x0E;
    public static final byte FACTORY_VALUE = 0x01;
    public static final String NAME = "Peripheral Adjustment";
    public static final byte LDO_D_LV_2_4 = Bit.parseBit();
    public static final byte LDO_D_LV_2_7 = Bit.parseBit(2);
    public static final byte RFLM_LV_5_2 = Bit.parseBit();
    public static final byte RFLM_LV_6_5 = Bit.parseBit(1);
    public static final byte RESP_FLAG_1_BIT = Bit.parseBit();
    public static final byte RESP_FLAG_2_BIT = Bit.parseBit(0);

    @Override
    public Type getType() {
        return Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_2:
                return "Define threshold voltage drop level at pin XVDD that set XVDD_RDY flag.\n" +
                        "\t0: 2.4 volt\n" +
                        "\t1: 2.7 volt";

            case BIT_1:
                return "Define RF limiter level to limit charging voltage on pin SCAP and pin HV\n" +
                        "\t0: 5.2 volt (maximum of SCAP voltage = 4.8 volt)\n" +
                        "\t1: 6.5 volt (maximum of SCAP voltage = 6.0 volt)";

            case BIT_0:
                return "Define the number of response flag in RF response packet to make the response compatible with some NFC chips/phone in market to guarantee minimum two byte in response frame.\n" +
                        "\t0: Response Flag in response package is set to one byte.\n" +
                        "\t1: Response Flag in response package is set to two bytes for some downlink commands to guarantee that uplink response frame contains at least 2 bytes to make operation compatible with some NFC phones in market that don't accept one bytes response.";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte LDO_D_LV = Bit.parseBit(2);
        public static final byte RFLM_LV = Bit.parseBit(1);
        public static final byte RESP_FLAG_N_BIT = Bit.parseBit(0);
    }
}
